import { Construct } from "constructs";
import { TerraformBackend } from "../terraform-backend";
import { TerraformRemoteState, DataTerraformRemoteStateConfig } from "../terraform-remote-state";
/**
 * @experimental
 */
export declare class S3Backend extends TerraformBackend {
    private readonly props;
    /**
     * @experimental
     */
    constructor(scope: Construct, props: S3BackendProps);
    /**
     * @experimental
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
/**
 * @experimental
 */
export declare class DataTerraformRemoteStateS3 extends TerraformRemoteState {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, config: DataTerraformRemoteStateS3Config);
}
/**
 * @experimental
 */
export interface S3BackendProps {
    /**
     * @experimental
     */
    readonly bucket: string;
    /**
     * @experimental
     */
    readonly key: string;
    /**
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    readonly endpoint?: string;
    /**
     * @experimental
     */
    readonly encrypt?: boolean;
    /**
     * @experimental
     */
    readonly acl?: string;
    /**
     * @experimental
     */
    readonly accessKey?: string;
    /**
     * @experimental
     */
    readonly secretKey?: string;
    /**
     * @experimental
     */
    readonly kmsKeyId?: string;
    /**
     * @experimental
     */
    readonly dynamodbTable?: string;
    /**
     * @experimental
     */
    readonly profile?: string;
    /**
     * @experimental
     */
    readonly sharedCredentialsFile?: string;
    /**
     * @experimental
     */
    readonly token?: string;
    /**
     * @experimental
     */
    readonly roleArn?: string;
    /**
     * @experimental
     */
    readonly assumeRolePolicy?: string;
    /**
     * @experimental
     */
    readonly externalId?: string;
    /**
     * @experimental
     */
    readonly sessionName?: string;
    /**
     * @experimental
     */
    readonly workspaceKeyPrefix?: string;
    /**
     * @experimental
     */
    readonly dynamodbEndpoint?: string;
    /**
     * @experimental
     */
    readonly iamEndpoint?: string;
    /**
     * @experimental
     */
    readonly stsEndpoint?: string;
    /**
     * @experimental
     */
    readonly forcePathStyle?: boolean;
    /**
     * @experimental
     */
    readonly skipCredentialsValidation?: boolean;
    /**
     * @experimental
     */
    readonly skipMetadataApiCheck?: boolean;
    /**
     * @experimental
     */
    readonly sseCustomerKey?: string;
    /**
     * @experimental
     */
    readonly maxRetries?: number;
}
/**
 * @experimental
 */
export interface DataTerraformRemoteStateS3Config extends DataTerraformRemoteStateConfig, S3BackendProps {
}
