import { ITerraformResource } from "./terraform-resource";
declare abstract class ComplexComputedAttribute {
    protected terraformResource: ITerraformResource;
    protected terraformAttribute: string;
    constructor(terraformResource: ITerraformResource, terraformAttribute: string);
    /**
     * @experimental
     */
    getStringAttribute(terraformAttribute: string): string;
    /**
     * @experimental
     */
    getNumberAttribute(terraformAttribute: string): number;
    /**
     * @experimental
     */
    getListAttribute(terraformAttribute: string): string[];
    /**
     * @experimental
     */
    getBooleanAttribute(terraformAttribute: string): any;
    protected abstract interpolationForAttribute(terraformAttribute: string): any;
}
/**
 * @experimental
 */
export declare class StringMap {
    protected terraformResource: ITerraformResource;
    protected terraformAttribute: string;
    /**
     * @experimental
     */
    constructor(terraformResource: ITerraformResource, terraformAttribute: string);
    /**
     * @experimental
     */
    lookup(key: string): string;
}
/**
 * @experimental
 */
export declare class NumberMap {
    protected terraformResource: ITerraformResource;
    protected terraformAttribute: string;
    /**
     * @experimental
     */
    constructor(terraformResource: ITerraformResource, terraformAttribute: string);
    /**
     * @experimental
     */
    lookup(key: string): number;
}
/**
 * @experimental
 */
export declare class BooleanMap {
    protected terraformResource: ITerraformResource;
    protected terraformAttribute: string;
    /**
     * @experimental
     */
    constructor(terraformResource: ITerraformResource, terraformAttribute: string);
    /**
     * @experimental
     */
    lookup(key: string): boolean;
}
/**
 * @experimental
 */
export declare class ComplexComputedList extends ComplexComputedAttribute {
    protected terraformResource: ITerraformResource;
    protected terraformAttribute: string;
    protected complexComputedListIndex: string;
    /**
     * @experimental
     */
    constructor(terraformResource: ITerraformResource, terraformAttribute: string, complexComputedListIndex: string);
    /**
     * @experimental
     */
    protected interpolationForAttribute(property: string): import("./tokens").IResolvable;
}
/**
 * @experimental
 */
export declare class ComplexObject extends ComplexComputedAttribute {
    protected terraformResource: ITerraformResource;
    protected terraformAttribute: string;
    protected isSingleItem: boolean;
    /**
     * @experimental
     */
    constructor(terraformResource: ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @experimental
     */
    protected interpolationForAttribute(property: string): import("./tokens").IResolvable;
    /**
     * @experimental
     */
    protected interpolationAsList(): import("./tokens").IResolvable;
}
export {};
