"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComplexObject = exports.ComplexComputedList = exports.BooleanMap = exports.NumberMap = exports.StringMap = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
class ComplexComputedAttribute {
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    /**
     * @experimental
     */
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
}
/**
 * @experimental
 */
class StringMap {
    /**
     * @experimental
     */
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    /**
     * @experimental
     */
    lookup(key) {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
}
exports.StringMap = StringMap;
_a = JSII_RTTI_SYMBOL_1;
StringMap[_a] = { fqn: "cdktf.StringMap", version: "0.9.0-pre.6" };
/**
 * @experimental
 */
class NumberMap {
    /**
     * @experimental
     */
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    /**
     * @experimental
     */
    lookup(key) {
        return tokens_1.Token.asNumber(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
}
exports.NumberMap = NumberMap;
_b = JSII_RTTI_SYMBOL_1;
NumberMap[_b] = { fqn: "cdktf.NumberMap", version: "0.9.0-pre.6" };
/**
 * @experimental
 */
class BooleanMap {
    /**
     * @experimental
     */
    constructor(terraformResource, terraformAttribute) {
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
    }
    /**
     * @experimental
     */
    lookup(key) {
        return tokens_1.Token.asString(this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}["${key}"]`));
    }
}
exports.BooleanMap = BooleanMap;
_c = JSII_RTTI_SYMBOL_1;
BooleanMap[_c] = { fqn: "cdktf.BooleanMap", version: "0.9.0-pre.6" };
/**
 * @experimental
 */
class ComplexComputedList extends ComplexComputedAttribute {
    /**
     * @experimental
     */
    constructor(terraformResource, terraformAttribute, complexComputedListIndex) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.complexComputedListIndex = complexComputedListIndex;
    }
    /**
     * @experimental
     */
    interpolationForAttribute(property) {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}.${this.complexComputedListIndex}.${property}`);
    }
}
exports.ComplexComputedList = ComplexComputedList;
_d = JSII_RTTI_SYMBOL_1;
ComplexComputedList[_d] = { fqn: "cdktf.ComplexComputedList", version: "0.9.0-pre.6" };
/**
 * @experimental
 */
class ComplexObject extends ComplexComputedAttribute {
    /**
     * @experimental
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.isSingleItem = isSingleItem;
    }
    /**
     * @experimental
     */
    interpolationForAttribute(property) {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}${this.isSingleItem ? "[0]" : ""}.${property}`);
    }
    /**
     * @experimental
     */
    interpolationAsList() {
        return this.terraformResource.interpolationForAttribute(`${this.terraformAttribute}.*`);
    }
}
exports.ComplexObject = ComplexObject;
_e = JSII_RTTI_SYMBOL_1;
ComplexObject[_e] = { fqn: "cdktf.ComplexObject", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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