/**
 * When set, the stack id is excluded from generated logical ids for constructs within the stack.
 */
export declare const EXCLUDE_STACK_ID_FROM_LOGICAL_IDS = "excludeStackIdFromLogicalIds";
/**
 * When set, '_' and '-' are allowed in logical ids.
 */
export declare const ALLOW_SEP_CHARS_IN_LOGICAL_IDS = "allowSepCharsInLogicalIds";
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdktf init` will include these flags in their
 * generated `cdktf.json` file.
 *
 * When we release the next major version of the CDK for Terraform, we will flip the logic of
 * these features and clean up the `cdktf.json` generated by `cdktf init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
export declare const FUTURE_FLAGS: {
    excludeStackIdFromLogicalIds: string;
    allowSepCharsInLogicalIds: string;
};
