import { TerraformStack } from "./terraform-stack";
import { AnnotationMetadataEntryType } from "./annotations";
/**
 * @experimental
 */
export interface StackAnnotation {
    /**
     * @experimental
     */
    readonly constructPath: string;
    /**
     * @experimental
     */
    readonly level: AnnotationMetadataEntryType;
    /**
     * @experimental
     */
    readonly message: string;
    /**
     * @experimental
     */
    readonly stacktrace?: string[];
}
/**
 * @experimental
 */
export interface StackManifest {
    /**
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    readonly constructPath: string;
    /**
     * @experimental
     */
    readonly synthesizedStackPath: string;
    /**
     * @experimental
     */
    readonly workingDirectory: string;
    /**
     * @experimental
     */
    readonly annotations: StackAnnotation[];
}
/**
 * @experimental
 */
export interface IManifest {
    /**
     * @experimental
     */
    readonly stacks: Record<StackManifest["name"], StackManifest>;
    /**
     * @experimental
     */
    readonly version: string;
}
/**
 * @experimental
 */
export declare class Manifest implements IManifest {
    readonly version: string;
    readonly outdir: string;
    /**
     * @experimental
     */
    static readonly fileName = "manifest.json";
    /**
     * @experimental
     */
    static readonly stacksFolder = "stacks";
    /**
     * @experimental
     */
    static readonly stackFileName = "cdk.tf.json";
    /**
     * @experimental
     */
    readonly stacks: Record<StackManifest["name"], StackManifest>;
    /**
     * @experimental
     */
    constructor(version: string, outdir: string);
    /**
     * @experimental
     */
    forStack(stack: TerraformStack): StackManifest;
    /**
     * @experimental
     */
    buildManifest(): IManifest;
    /**
     * @experimental
     */
    writeToFile(): void;
}
