"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Manifest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const fs = require("fs");
/**
 * @experimental
 */
class Manifest {
    /**
     * @experimental
     */
    constructor(version, outdir) {
        this.version = version;
        this.outdir = outdir;
        /**
         * @experimental
         */
        this.stacks = {};
        const stacksPath = path.join(this.outdir, Manifest.stacksFolder);
        if (!fs.existsSync(stacksPath))
            fs.mkdirSync(stacksPath);
    }
    /**
     * @experimental
     */
    forStack(stack) {
        const node = stack.node;
        const name = node.id;
        if (this.stacks[name]) {
            return this.stacks[name];
        }
        const manifest = {
            name,
            constructPath: node.path,
            workingDirectory: path.join(Manifest.stacksFolder, node.id),
            synthesizedStackPath: path.join(Manifest.stacksFolder, node.id, Manifest.stackFileName),
            annotations: [],
        };
        this.stacks[name] = manifest;
        return manifest;
    }
    /**
     * @experimental
     */
    buildManifest() {
        return {
            version: this.version,
            stacks: this.stacks,
        };
    }
    /**
     * @experimental
     */
    writeToFile() {
        fs.writeFileSync(path.join(this.outdir, Manifest.fileName), JSON.stringify(this.buildManifest(), undefined, 2));
    }
}
exports.Manifest = Manifest;
_a = JSII_RTTI_SYMBOL_1;
Manifest[_a] = { fqn: "cdktf.Manifest", version: "0.9.0-pre.6" };
/**
 * @experimental
 */
Manifest.fileName = "manifest.json";
/**
 * @experimental
 */
Manifest.stacksFolder = "stacks";
/**
 * @experimental
 */
Manifest.stackFileName = "cdk.tf.json";
//# sourceMappingURL=data:application/json;base64,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