"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashPath = exports.archiveSync = exports.copySync = void 0;
const child_process_1 = require("child_process");
const fs = require("fs");
const path = require("path");
const crypto = require("crypto");
const HASH_LEN = 32;
// Full implementation at https://github.com/jprichardson/node-fs-extra/blob/master/lib/copy-sync/copy-sync.js
function copySync(src, dest) {
    function copyItem(p) {
        const sourcePath = path.resolve(src, p);
        const stat = fs.statSync(sourcePath);
        if (stat.isFile()) {
            fs.copyFileSync(sourcePath, path.resolve(dest, p));
        }
        if (stat.isDirectory()) {
            walkSubfolder(p);
        }
    }
    function walkSubfolder(p) {
        const sourceDir = path.resolve(src, p);
        fs.mkdirSync(path.resolve(dest, p), { recursive: true });
        fs.readdirSync(sourceDir).forEach((item) => copyItem(path.join(p, item)));
    }
    walkSubfolder(".");
}
exports.copySync = copySync;
function archiveSync(src, dest) {
    const projectRoot = path.resolve(__dirname, "..", "..");
    const zipSyncPath = path.resolve(projectRoot, "bin", "zipSync.js");
    child_process_1.execSync(`node ${zipSyncPath} ${src} ${dest}`);
}
exports.archiveSync = archiveSync;
function hashPath(src) {
    const hash = crypto.createHash("md5");
    function hashRecursion(p) {
        const stat = fs.statSync(p);
        if (stat.isFile()) {
            hash.update(fs.readFileSync(p));
        }
        else if (stat.isDirectory()) {
            fs.readdirSync(p).forEach((filename) => hashRecursion(path.resolve(p, filename)));
        }
    }
    hashRecursion(src);
    return hash.digest("hex").slice(0, HASH_LEN).toUpperCase();
}
exports.hashPath = hashPath;
//# sourceMappingURL=data:application/json;base64,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