import { Manifest } from "../manifest";
/**
 * (experimental) Encodes information how a certain Stack should be deployed inspired by AWS CDK v2 implementation (synth functionality was removed in constructs v10).
 *
 * @experimental
 */
export interface IStackSynthesizer {
    /**
     * (experimental) Synthesize the associated stack to the session.
     *
     * @experimental
     */
    synthesize(session: ISynthesisSession): void;
}
/**
 * (experimental) Represents a single session of synthesis.
 *
 * Passed into `TerraformStack.onSynthesize()` methods.
 * originally from aws/constructs lib v3.3.126 (synth functionality was removed in constructs v10)
 *
 * @experimental
 */
export interface ISynthesisSession {
    /**
     * (experimental) The output directory for this synthesis session.
     *
     * @experimental
     */
    readonly outdir: string;
    /**
     * @experimental
     */
    readonly skipValidation?: boolean;
    /**
     * @experimental
     */
    readonly manifest: Manifest;
    /**
     * Additional context passed to synthesizeNode through `sessionContext`.
     */
    [key: string]: any;
}
