import { Construct } from "constructs";
import { Resource } from "./resource";
/**
 * @experimental
 */
export interface TerraformAssetConfig {
    /**
     * @experimental
     */
    readonly path: string;
    /**
     * @experimental
     */
    readonly type?: AssetType;
    /**
     * @experimental
     */
    readonly assetHash?: string;
}
/**
 * @experimental
 */
export declare enum AssetType {
    /**
     * @experimental
     */
    FILE = 0,
    /**
     * @experimental
     */
    DIRECTORY = 1,
    /**
     * @experimental
     */
    ARCHIVE = 2
}
/**
 * @experimental
 */
export declare class TerraformAsset extends Resource {
    private sourcePath;
    /**
     * @experimental
     */
    assetHash: string;
    /**
     * @experimental
     */
    type: AssetType;
    /**
     * (experimental) A Terraform Asset takes a file or directory outside of the CDK for Terraform context and moves it into it.
     *
     * Assets copy referenced files into the stacks context for further usage in other resources.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, config: TerraformAssetConfig);
    private get namedFolder();
    /**
     * (experimental) The path relative to the root of the terraform directory in posix format Use this property to reference the asset.
     *
     * @experimental
     */
    get path(): string;
    /**
     * (experimental) Name of the asset.
     *
     * @experimental
     */
    get fileName(): string;
    private _onSynthesize;
}
