"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformAsset = exports.AssetType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const fs_1 = require("./private/fs");
const resource_1 = require("./resource");
const synthesizer_1 = require("./synthesize/synthesizer");
/**
 * @experimental
 */
var AssetType;
(function (AssetType) {
    AssetType[AssetType["FILE"] = 0] = "FILE";
    AssetType[AssetType["DIRECTORY"] = 1] = "DIRECTORY";
    AssetType[AssetType["ARCHIVE"] = 2] = "ARCHIVE";
})(AssetType = exports.AssetType || (exports.AssetType = {}));
const ARCHIVE_NAME = "archive.zip";
const ASSETS_DIRECTORY = "assets";
/**
 * @experimental
 */
class TerraformAsset extends resource_1.Resource {
    /**
     * (experimental) A Terraform Asset takes a file or directory outside of the CDK for Terraform context and moves it into it.
     *
     * Assets copy referenced files into the stacks context for further usage in other resources.
     *
     * @experimental
     */
    constructor(scope, id, config) {
        var _b;
        super(scope, id);
        if (!path.isAbsolute(config.path)) {
            throw new Error(`TerraformAsset path needs to be absolute, got relative path: '${config.path}'`);
        }
        const stat = fs.statSync(config.path);
        const inferredType = stat.isFile() ? AssetType.FILE : AssetType.DIRECTORY;
        this.type = (_b = config.type) !== null && _b !== void 0 ? _b : inferredType;
        this.sourcePath = config.path;
        this.assetHash = config.assetHash || fs_1.hashPath(this.sourcePath);
        if (stat.isFile() && this.type !== AssetType.FILE) {
            throw new Error(`TerraformAsset ${id} expects path to be a directory, a file was passed: '${config.path}'`);
        }
        if (!stat.isFile() && this.type === AssetType.FILE) {
            throw new Error(`TerraformAsset ${id} expects path to be a file, a directory was passed: '${config.path}'`);
        }
        synthesizer_1.addCustomSynthesis(this, {
            onSynthesize: this._onSynthesize.bind(this),
        });
    }
    get namedFolder() {
        return path.posix.join(ASSETS_DIRECTORY, this.stack.getLogicalId(this.node));
    }
    /**
     * (experimental) The path relative to the root of the terraform directory in posix format Use this property to reference the asset.
     *
     * @experimental
     */
    get path() {
        return path.posix.join(this.namedFolder, // readable name
        this.assetHash, // hash depending on content so that path changes if content changes
        this.type === AssetType.DIRECTORY ? "" : this.fileName);
    }
    /**
     * (experimental) Name of the asset.
     *
     * @experimental
     */
    get fileName() {
        switch (this.type) {
            case AssetType.ARCHIVE:
                return ARCHIVE_NAME;
            default:
                return path.basename(this.sourcePath);
        }
    }
    _onSynthesize(session) {
        const stackManifest = session.manifest.forStack(this.stack);
        const basePath = path.join(session.manifest.outdir, stackManifest.synthesizedStackPath, "..");
        // Cleanup existing assets
        const previousVersionsFolder = path.join(basePath, this.namedFolder);
        if (fs.existsSync(previousVersionsFolder)) {
            fs.rmdirSync(previousVersionsFolder, { recursive: true });
        }
        const targetPath = path.join(basePath, this.path);
        if (this.type === AssetType.DIRECTORY) {
            fs.mkdirSync(targetPath, { recursive: true });
        }
        else {
            fs.mkdirSync(path.dirname(targetPath), { recursive: true });
        }
        switch (this.type) {
            case AssetType.FILE:
                fs.copyFileSync(this.sourcePath, targetPath);
                break;
            case AssetType.DIRECTORY:
                fs_1.copySync(this.sourcePath, targetPath);
                break;
            case AssetType.ARCHIVE:
                fs_1.archiveSync(this.sourcePath, targetPath);
                break;
            default:
                throw new Error(`Asset type ${this.type} is not implemented`);
        }
    }
}
exports.TerraformAsset = TerraformAsset;
_a = JSII_RTTI_SYMBOL_1;
TerraformAsset[_a] = { fqn: "cdktf.TerraformAsset", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLWFzc2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidGVycmFmb3JtLWFzc2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0EseUJBQXlCO0FBQ3pCLDZCQUE2QjtBQUM3QixxQ0FBK0Q7QUFDL0QseUNBQXNDO0FBRXRDLDBEQUE4RDs7OztBQVc5RCxJQUFZLFNBSVg7QUFKRCxXQUFZLFNBQVM7SUFDbkIseUNBQUksQ0FBQTtJQUNKLG1EQUFTLENBQUE7SUFDVCwrQ0FBTyxDQUFBO0FBQ1QsQ0FBQyxFQUpXLFNBQVMsR0FBVCxpQkFBUyxLQUFULGlCQUFTLFFBSXBCO0FBRUQsTUFBTSxZQUFZLEdBQUcsYUFBYSxDQUFDO0FBQ25DLE1BQU0sZ0JBQWdCLEdBQUcsUUFBUSxDQUFDOzs7O0FBRWxDLE1BQWEsY0FBZSxTQUFRLG1CQUFROzs7Ozs7OztJQVExQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQTRCOztRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsRUFBRTtZQUNqQyxNQUFNLElBQUksS0FBSyxDQUNiLGlFQUFpRSxNQUFNLENBQUMsSUFBSSxHQUFHLENBQ2hGLENBQUM7U0FDSDtRQUVELE1BQU0sSUFBSSxHQUFHLEVBQUUsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3RDLE1BQU0sWUFBWSxHQUFHLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQztRQUMxRSxJQUFJLENBQUMsSUFBSSxTQUFHLE1BQU0sQ0FBQyxJQUFJLG1DQUFJLFlBQVksQ0FBQztRQUN4QyxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDOUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsU0FBUyxJQUFJLGFBQVEsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFL0QsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxTQUFTLENBQUMsSUFBSSxFQUFFO1lBQ2pELE1BQU0sSUFBSSxLQUFLLENBQ2Isa0JBQWtCLEVBQUUsd0RBQXdELE1BQU0sQ0FBQyxJQUFJLEdBQUcsQ0FDM0YsQ0FBQztTQUNIO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsSUFBSSxJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsQ0FBQyxJQUFJLEVBQUU7WUFDbEQsTUFBTSxJQUFJLEtBQUssQ0FDYixrQkFBa0IsRUFBRSx3REFBd0QsTUFBTSxDQUFDLElBQUksR0FBRyxDQUMzRixDQUFDO1NBQ0g7UUFFRCxnQ0FBa0IsQ0FBQyxJQUFJLEVBQUU7WUFDdkIsWUFBWSxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQztTQUM1QyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsSUFBWSxXQUFXO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQ3BCLGdCQUFnQixFQUNoQixJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQ25DLENBQUM7SUFDSixDQUFDOzs7Ozs7SUFHRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUNwQixJQUFJLENBQUMsV0FBVyxFQUFFLGdCQUFnQjtRQUNsQyxJQUFJLENBQUMsU0FBUyxFQUFFLG9FQUFvRTtRQUNwRixJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FDdkQsQ0FBQztJQUNKLENBQUM7Ozs7OztJQUdELElBQVcsUUFBUTtRQUNqQixRQUFRLElBQUksQ0FBQyxJQUFJLEVBQUU7WUFDakIsS0FBSyxTQUFTLENBQUMsT0FBTztnQkFDcEIsT0FBTyxZQUFZLENBQUM7WUFDdEI7Z0JBQ0UsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztTQUN6QztJQUNILENBQUM7SUFFTyxhQUFhLENBQUMsT0FBMEI7UUFDOUMsTUFBTSxhQUFhLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzVELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQ3hCLE9BQU8sQ0FBQyxRQUFRLENBQUMsTUFBTSxFQUN2QixhQUFhLENBQUMsb0JBQW9CLEVBQ2xDLElBQUksQ0FDTCxDQUFDO1FBRUYsMEJBQTBCO1FBQzFCLE1BQU0sc0JBQXNCLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ3JFLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxFQUFFO1lBQ3pDLEVBQUUsQ0FBQyxTQUFTLENBQUMsc0JBQXNCLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUMzRDtRQUVELE1BQU0sVUFBVSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVsRCxJQUFJLElBQUksQ0FBQyxJQUFJLEtBQUssU0FBUyxDQUFDLFNBQVMsRUFBRTtZQUNyQyxFQUFFLENBQUMsU0FBUyxDQUFDLFVBQVUsRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1NBQy9DO2FBQU07WUFDTCxFQUFFLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLEVBQUUsRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUM3RDtRQUVELFFBQVEsSUFBSSxDQUFDLElBQUksRUFBRTtZQUNqQixLQUFLLFNBQVMsQ0FBQyxJQUFJO2dCQUNqQixFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDLENBQUM7Z0JBQzdDLE1BQU07WUFFUixLQUFLLFNBQVMsQ0FBQyxTQUFTO2dCQUN0QixhQUFRLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztnQkFDdEMsTUFBTTtZQUVSLEtBQUssU0FBUyxDQUFDLE9BQU87Z0JBQ3BCLGdCQUFXLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztnQkFDekMsTUFBTTtZQUNSO2dCQUNFLE1BQU0sSUFBSSxLQUFLLENBQUMsY0FBYyxJQUFJLENBQUMsSUFBSSxxQkFBcUIsQ0FBQyxDQUFDO1NBQ2pFO0lBQ0gsQ0FBQzs7QUF2R0gsd0NBd0dDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCAqIGFzIGZzIGZyb20gXCJmc1wiO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0IHsgY29weVN5bmMsIGFyY2hpdmVTeW5jLCBoYXNoUGF0aCB9IGZyb20gXCIuL3ByaXZhdGUvZnNcIjtcbmltcG9ydCB7IFJlc291cmNlIH0gZnJvbSBcIi4vcmVzb3VyY2VcIjtcbmltcG9ydCB7IElTeW50aGVzaXNTZXNzaW9uIH0gZnJvbSBcIi4vc3ludGhlc2l6ZVwiO1xuaW1wb3J0IHsgYWRkQ3VzdG9tU3ludGhlc2lzIH0gZnJvbSBcIi4vc3ludGhlc2l6ZS9zeW50aGVzaXplclwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIFRlcnJhZm9ybUFzc2V0Q29uZmlnIHtcbiAgLy8gYWJzb2x1dGUgcGF0aCB0byB0aGUgZmlsZSBvciBmb2xkZXIgY29uZmlndXJlZFxuICByZWFkb25seSBwYXRoOiBzdHJpbmc7XG4gIC8vIGZpbGUgdHlwZSBvZiB0aGUgYXNzZXQsIGVpdGhlciBBc3NldFR5cGUuRklMRSwgQXNzZXRUeXBlLkRJUkVDVE9SWSwgQXNzZXRUeXBlLkFSQ0hJVkVcbiAgcmVhZG9ubHkgdHlwZT86IEFzc2V0VHlwZTtcbiAgLy8gaGFzaCB2YWx1ZSBvZiB0aGUgYXNzZXQsIGlmIHBhc3NlZCB3aWxsIGJlIHVzZWQgYXMgcmV0dXJuZWQgYXNzZXRIYXNoXG4gIHJlYWRvbmx5IGFzc2V0SGFzaD86IHN0cmluZztcbn1cblxuZXhwb3J0IGVudW0gQXNzZXRUeXBlIHtcbiAgRklMRSxcbiAgRElSRUNUT1JZLFxuICBBUkNISVZFLFxufVxuXG5jb25zdCBBUkNISVZFX05BTUUgPSBcImFyY2hpdmUuemlwXCI7XG5jb25zdCBBU1NFVFNfRElSRUNUT1JZID0gXCJhc3NldHNcIjtcblxuZXhwb3J0IGNsYXNzIFRlcnJhZm9ybUFzc2V0IGV4dGVuZHMgUmVzb3VyY2Uge1xuICBwcml2YXRlIHNvdXJjZVBhdGg6IHN0cmluZztcbiAgLy8gaGFzaCB2YWx1ZSBvZiB0aGUgYXNzZXQgdGhhdCBjYW4gYmUgcGFzc2VkIHRvIGNvbnN1bWluZyBjb25zdHJ1Y3RzIChlLmcuIHRvIG5vdCByZWNyZWF0ZSBhIGxhbWJkYSBmdW5jdGlvbiBpbiBjYXNlIHRoZSB1bmRlcmx5aW5nIGZpbGVzIGRpZCBub3QgY2hhbmdlKVxuICBwdWJsaWMgYXNzZXRIYXNoOiBzdHJpbmc7XG4gIC8vIGZpbGUgdHlwZSBvZiB0aGUgYXNzZXQsIGVpdGhlciBBc3NldFR5cGUuRklMRSwgQXNzZXRUeXBlLkRJUkVDVE9SWSwgQXNzZXRUeXBlLkFSQ0hJVkVcbiAgcHVibGljIHR5cGU6IEFzc2V0VHlwZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IFRlcnJhZm9ybUFzc2V0Q29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGlmICghcGF0aC5pc0Fic29sdXRlKGNvbmZpZy5wYXRoKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICBgVGVycmFmb3JtQXNzZXQgcGF0aCBuZWVkcyB0byBiZSBhYnNvbHV0ZSwgZ290IHJlbGF0aXZlIHBhdGg6ICcke2NvbmZpZy5wYXRofSdgXG4gICAgICApO1xuICAgIH1cblxuICAgIGNvbnN0IHN0YXQgPSBmcy5zdGF0U3luYyhjb25maWcucGF0aCk7XG4gICAgY29uc3QgaW5mZXJyZWRUeXBlID0gc3RhdC5pc0ZpbGUoKSA/IEFzc2V0VHlwZS5GSUxFIDogQXNzZXRUeXBlLkRJUkVDVE9SWTtcbiAgICB0aGlzLnR5cGUgPSBjb25maWcudHlwZSA/PyBpbmZlcnJlZFR5cGU7XG4gICAgdGhpcy5zb3VyY2VQYXRoID0gY29uZmlnLnBhdGg7XG4gICAgdGhpcy5hc3NldEhhc2ggPSBjb25maWcuYXNzZXRIYXNoIHx8IGhhc2hQYXRoKHRoaXMuc291cmNlUGF0aCk7XG5cbiAgICBpZiAoc3RhdC5pc0ZpbGUoKSAmJiB0aGlzLnR5cGUgIT09IEFzc2V0VHlwZS5GSUxFKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIGBUZXJyYWZvcm1Bc3NldCAke2lkfSBleHBlY3RzIHBhdGggdG8gYmUgYSBkaXJlY3RvcnksIGEgZmlsZSB3YXMgcGFzc2VkOiAnJHtjb25maWcucGF0aH0nYFxuICAgICAgKTtcbiAgICB9XG5cbiAgICBpZiAoIXN0YXQuaXNGaWxlKCkgJiYgdGhpcy50eXBlID09PSBBc3NldFR5cGUuRklMRSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICBgVGVycmFmb3JtQXNzZXQgJHtpZH0gZXhwZWN0cyBwYXRoIHRvIGJlIGEgZmlsZSwgYSBkaXJlY3Rvcnkgd2FzIHBhc3NlZDogJyR7Y29uZmlnLnBhdGh9J2BcbiAgICAgICk7XG4gICAgfVxuXG4gICAgYWRkQ3VzdG9tU3ludGhlc2lzKHRoaXMsIHtcbiAgICAgIG9uU3ludGhlc2l6ZTogdGhpcy5fb25TeW50aGVzaXplLmJpbmQodGhpcyksXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIGdldCBuYW1lZEZvbGRlcigpOiBzdHJpbmcge1xuICAgIHJldHVybiBwYXRoLnBvc2l4LmpvaW4oXG4gICAgICBBU1NFVFNfRElSRUNUT1JZLFxuICAgICAgdGhpcy5zdGFjay5nZXRMb2dpY2FsSWQodGhpcy5ub2RlKVxuICAgICk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgcGF0aCgpOiBzdHJpbmcge1xuICAgIHJldHVybiBwYXRoLnBvc2l4LmpvaW4oXG4gICAgICB0aGlzLm5hbWVkRm9sZGVyLCAvLyByZWFkYWJsZSBuYW1lXG4gICAgICB0aGlzLmFzc2V0SGFzaCwgLy8gaGFzaCBkZXBlbmRpbmcgb24gY29udGVudCBzbyB0aGF0IHBhdGggY2hhbmdlcyBpZiBjb250ZW50IGNoYW5nZXNcbiAgICAgIHRoaXMudHlwZSA9PT0gQXNzZXRUeXBlLkRJUkVDVE9SWSA/IFwiXCIgOiB0aGlzLmZpbGVOYW1lXG4gICAgKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBnZXQgZmlsZU5hbWUoKTogc3RyaW5nIHtcbiAgICBzd2l0Y2ggKHRoaXMudHlwZSkge1xuICAgICAgY2FzZSBBc3NldFR5cGUuQVJDSElWRTpcbiAgICAgICAgcmV0dXJuIEFSQ0hJVkVfTkFNRTtcbiAgICAgIGRlZmF1bHQ6XG4gICAgICAgIHJldHVybiBwYXRoLmJhc2VuYW1lKHRoaXMuc291cmNlUGF0aCk7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBfb25TeW50aGVzaXplKHNlc3Npb246IElTeW50aGVzaXNTZXNzaW9uKSB7XG4gICAgY29uc3Qgc3RhY2tNYW5pZmVzdCA9IHNlc3Npb24ubWFuaWZlc3QuZm9yU3RhY2sodGhpcy5zdGFjayk7XG4gICAgY29uc3QgYmFzZVBhdGggPSBwYXRoLmpvaW4oXG4gICAgICBzZXNzaW9uLm1hbmlmZXN0Lm91dGRpcixcbiAgICAgIHN0YWNrTWFuaWZlc3Quc3ludGhlc2l6ZWRTdGFja1BhdGgsXG4gICAgICBcIi4uXCJcbiAgICApO1xuXG4gICAgLy8gQ2xlYW51cCBleGlzdGluZyBhc3NldHNcbiAgICBjb25zdCBwcmV2aW91c1ZlcnNpb25zRm9sZGVyID0gcGF0aC5qb2luKGJhc2VQYXRoLCB0aGlzLm5hbWVkRm9sZGVyKTtcbiAgICBpZiAoZnMuZXhpc3RzU3luYyhwcmV2aW91c1ZlcnNpb25zRm9sZGVyKSkge1xuICAgICAgZnMucm1kaXJTeW5jKHByZXZpb3VzVmVyc2lvbnNGb2xkZXIsIHsgcmVjdXJzaXZlOiB0cnVlIH0pO1xuICAgIH1cblxuICAgIGNvbnN0IHRhcmdldFBhdGggPSBwYXRoLmpvaW4oYmFzZVBhdGgsIHRoaXMucGF0aCk7XG5cbiAgICBpZiAodGhpcy50eXBlID09PSBBc3NldFR5cGUuRElSRUNUT1JZKSB7XG4gICAgICBmcy5ta2RpclN5bmModGFyZ2V0UGF0aCwgeyByZWN1cnNpdmU6IHRydWUgfSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGZzLm1rZGlyU3luYyhwYXRoLmRpcm5hbWUodGFyZ2V0UGF0aCksIHsgcmVjdXJzaXZlOiB0cnVlIH0pO1xuICAgIH1cblxuICAgIHN3aXRjaCAodGhpcy50eXBlKSB7XG4gICAgICBjYXNlIEFzc2V0VHlwZS5GSUxFOlxuICAgICAgICBmcy5jb3B5RmlsZVN5bmModGhpcy5zb3VyY2VQYXRoLCB0YXJnZXRQYXRoKTtcbiAgICAgICAgYnJlYWs7XG5cbiAgICAgIGNhc2UgQXNzZXRUeXBlLkRJUkVDVE9SWTpcbiAgICAgICAgY29weVN5bmModGhpcy5zb3VyY2VQYXRoLCB0YXJnZXRQYXRoKTtcbiAgICAgICAgYnJlYWs7XG5cbiAgICAgIGNhc2UgQXNzZXRUeXBlLkFSQ0hJVkU6XG4gICAgICAgIGFyY2hpdmVTeW5jKHRoaXMuc291cmNlUGF0aCwgdGFyZ2V0UGF0aCk7XG4gICAgICAgIGJyZWFrO1xuICAgICAgZGVmYXVsdDpcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBBc3NldCB0eXBlICR7dGhpcy50eXBlfSBpcyBub3QgaW1wbGVtZW50ZWRgKTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==