"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformBackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
/**
 * @experimental
 */
class TerraformBackend extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, name) {
        super(scope, id);
        this.name = name;
    }
    // jsii can't handle abstract classes?
    /**
     * @experimental
     */
    synthesizeAttributes() {
        return {};
    }
    /**
     * (experimental) Adds this resource to the terraform JSON output.
     *
     * @experimental
     */
    toTerraform() {
        return {
            terraform: {
                backend: {
                    [this.name]: util_1.deepMerge(this.synthesizeAttributes(), this.rawOverrides),
                },
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        return {
            backend: this.name,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { backend: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.TerraformBackend = TerraformBackend;
_a = JSII_RTTI_SYMBOL_1;
TerraformBackend[_a] = { fqn: "cdktf.TerraformBackend", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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