import { Construct } from "constructs";
import { IResolvable } from "./tokens";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { TerraformProviderGeneratorMetadata, TerraformResourceConfig, TerraformResourceLifecycle, ITerraformResource } from "./terraform-resource";
import { ITerraformDependable } from "./terraform-dependable";
/**
 * @experimental
 */
export declare class TerraformDataSource extends TerraformElement implements ITerraformResource, ITerraformDependable {
    /**
     * @experimental
     */
    readonly terraformResourceType: string;
    /**
     * @experimental
     */
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
    /**
     * @experimental
     */
    dependsOn?: string[];
    /**
     * @experimental
     */
    count?: number | IResolvable;
    /**
     * @experimental
     */
    provider?: TerraformProvider;
    /**
     * @experimental
     */
    lifecycle?: TerraformResourceLifecycle;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, config: TerraformResourceConfig);
    /**
     * @experimental
     */
    getStringAttribute(terraformAttribute: string): string;
    /**
     * @experimental
     */
    getNumberAttribute(terraformAttribute: string): number;
    /**
     * @experimental
     */
    getListAttribute(terraformAttribute: string): string[];
    /**
     * @experimental
     */
    getBooleanAttribute(terraformAttribute: string): IResolvable;
    /**
     * @experimental
     */
    get fqn(): string;
    /**
     * @experimental
     */
    get terraformMetaArguments(): {
        [name: string]: any;
    };
    /**
     * @experimental
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    /**
     * (experimental) Adds this resource to the terraform JSON output.
     *
     * @experimental
     */
    toTerraform(): any;
    /**
     * @experimental
     */
    toMetadata(): any;
    /**
     * @experimental
     */
    interpolationForAttribute(terraformAttribute: string): IResolvable;
}
