"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformDataSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
/**
 * @experimental
 */
class TerraformDataSource extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, config) {
        super(scope, id);
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        if (Array.isArray(config.dependsOn)) {
            this.dependsOn = config.dependsOn.map((dependency) => dependency.fqn);
        }
        this.count = config.count;
        this.provider = config.provider;
        this.lifecycle = config.lifecycle;
    }
    /**
     * @experimental
     */
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    /**
     * @experimental
     */
    get fqn() {
        return tokens_1.Token.asString(`data.${this.terraformResourceType}.${this.friendlyUniqueId}`);
    }
    /**
     * @experimental
     */
    get terraformMetaArguments() {
        var _b;
        return {
            dependsOn: this.dependsOn,
            count: this.count,
            provider: (_b = this.provider) === null || _b === void 0 ? void 0 : _b.fqn,
            lifecycle: this.lifecycle,
        };
    }
    // jsii can't handle abstract classes?
    /**
     * @experimental
     */
    synthesizeAttributes() {
        return {};
    }
    /**
     * (experimental) Adds this resource to the terraform JSON output.
     *
     * @experimental
     */
    toTerraform() {
        const attributes = util_1.deepMerge(this.synthesizeAttributes(), util_1.keysToSnakeCase(this.terraformMetaArguments), this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            data: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
    /**
     * @experimental
     */
    interpolationForAttribute(terraformAttribute) {
        return tfExpression_1.ref(`data.${this.terraformResourceType}.${this.friendlyUniqueId}.${terraformAttribute}`);
    }
}
exports.TerraformDataSource = TerraformDataSource;
_a = JSII_RTTI_SYMBOL_1;
TerraformDataSource[_a] = { fqn: "cdktf.TerraformDataSource", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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