import { IResolvable } from "./tokens/resolvable";
/**
 * @experimental
 */
export declare class Fn {
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/anytrue.html anytrue} returns true if all elements in a given collection are true or "true".
     *
     * @experimental
     */
    static alltrue(values: any[]): IResolvable;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/anytrue.html anytrue} returns true if any element in a given collection is true or "true".
     *
     * @experimental
     */
    static anytrue(value: any[]): IResolvable;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/chunklist.html chunklist} splits a single list into fixed-size chunks, returning a list of lists.
     *
     * @experimental
     */
    static chunklist(value: any[], chunkSize: number | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/coalesce.html coalesce} takes any number of arguments and returns the first one that isn't null or an empty string.
     *
     * @param value - Arguments are passed in an array.
     * @experimental
     */
    static coalesce(value: any[]): IResolvable;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/coalescelist.html coalescelist} takes any number of list arguments and returns the first one that isn't empty.
     *
     * @experimental
     */
    static coalescelist(value: any[][]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/compact.html compact} takes a list of strings and returns a new list with any empty string elements removed.
     *
     * @experimental
     */
    static compact(value: string[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/concat.html concat} takes two or more lists and combines them into a single list.
     *
     * @experimental
     */
    static concat(value: any[][]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/contains.html contains} determines whether a given list or set contains a given single value as one of its elements.
     *
     * @experimental
     */
    static contains(list: any[], value: any): IResolvable;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/distinct.html distinct} takes a list and returns a new list with any duplicate elements removed.
     *
     * @experimental
     */
    static distinct(list: any[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/element.html element} retrieves a single element from a list.
     *
     * @experimental
     */
    static element(list: any[] | IResolvable, index: number | IResolvable): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/flatten.html flatten} takes a list and replaces any elements that are lists with a flattened sequence of the list contents.
     *
     * @experimental
     */
    static flatten(list: any[] | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/index.html index} finds the element index for a given value in a list.
     *
     * @experimental
     */
    static index(list: any[] | IResolvable, value: any): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/keys.html keys} takes a map and returns a list containing the keys from that map.
     *
     * @experimental
     */
    static keys(map: Record<string, any> | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/length.html length} determines the length of a given list, map, or string.
     *
     * @experimental
     */
    static lengthOf(value: any): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/lookup.html lookup} retrieves the value of a single element from a map, given its key. If the given key does not exist, the given default value is returned instead.
     *
     * @experimental
     */
    static lookup(value: any, key: any, defaultValue: any): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/matchkeys.html matchkeys} constructs a new list by taking a subset of elements from one list whose indexes match the corresponding indexes of values in another list.
     *
     * @experimental
     */
    static matchkeys(valuesList: any[] | string, keysList: any[] | string, searchSet: any[] | string): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/merge.html merge} takes an arbitrary number of maps or objects, and returns a single map or object that contains a merged set of elements from all arguments.
     *
     * @experimental
     */
    static merge(values: any[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/one.html one} takes a list, set, or tuple value with either zero or one elements.
     *
     * @experimental
     */
    static one(list: any[] | string): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/range.html range} generates a list of numbers using a start value, a limit value, and a step value.
     *
     * @experimental
     */
    static range(start: number | IResolvable, limit: number | IResolvable, step?: number): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/reverse.html reverse} takes a sequence and produces a new sequence of the same length with all of the same elements as the given sequence but in reverse order.
     *
     * @experimental
     */
    static reverse(values: any[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/setintersection.html setintersection} function takes multiple sets and produces a single set containing only the elements that all of the given sets have in common.
     *
     * @experimental
     */
    static setintersection(values: any[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/setproduct.html setproduct} function finds all of the possible combinations of elements from all of the given sets by computing the Cartesian product.
     *
     * @experimental
     */
    static setproduct(values: any[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/slice.html setsubtract} function returns a new set containing the elements from the first set that are not present in the second set.
     *
     * @experimental
     */
    static setsubtract(minuend: any[] | string, subtrahend: any[] | string): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/setunion.html setunion} function takes multiple sets and produces a single set containing the elements from all of the given sets.
     *
     * @param values - Arguments are passed in an array.
     * @experimental
     */
    static setunion(values: any[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/slice.html slice} extracts some consecutive elements from within a list.
     *
     * @experimental
     */
    static slice(list: any[] | string, startindex: number | IResolvable, endindex: number | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/sort.html sort} takes a list of strings and returns a new list with those strings sorted lexicographically.
     *
     * @experimental
     */
    static sort(list: any[] | string): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/sum.html sum} takes a list or set of numbers and returns the sum of those numbers.
     *
     * @experimental
     */
    static sum(list: any[] | string): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/transpose.html transpose} takes a map of lists of strings and swaps the keys and values to produce a new map of lists of strings.
     *
     * @experimental
     */
    static transpose(value: any): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/values.html values} takes a map and returns a list containing the values of the elements in that map.
     *
     * @experimental
     */
    static values(value: any): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/zipmap.html zipmap} constructs a map from a list of keys and a corresponding list of values.
     *
     * @experimental
     */
    static zipmap(keyslist: any[], valueslist: any[]): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/base64sha256.html base64sha256} computes the SHA256 hash of a given string and encodes it with Base64.
     *
     * @experimental
     */
    static base64sha256(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/base64sha512.html base64sha512} computes the SHA512 hash of a given string and encodes it with Base64.
     *
     * @experimental
     */
    static base64sha512(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/bcrypt.html bcrypt} computes a hash of the given string using the Blowfish cipher, returning a string in the Modular Crypt Format usually expected in the shadow password file on many Unix systems.
     *
     * @experimental
     */
    static bcrypt(value: string | IResolvable, cost?: number | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/filebase64sha256.html filebase64sha256} is a variant of base64sha256 that hashes the contents of a given file rather than a literal string.
     *
     * @experimental
     */
    static filebase64sha256(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/filebase64sha512.html filebase64sha512} is a variant of base64sha512 that hashes the contents of a given file rather than a literal string.
     *
     * @experimental
     */
    static filebase64sha512(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/filemd5.html filemd5} is a variant of md5 that hashes the contents of a given file rather than a literal string.
     *
     * @experimental
     */
    static filemd5(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/filesha1.html filesha1} is a variant of sha1 that hashes the contents of a given file rather than a literal string.
     *
     * @experimental
     */
    static filesha1(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/filesha256.html filesha256} is a variant of sha256 that hashes the contents of a given file rather than a literal string.
     *
     * @experimental
     */
    static filesha256(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/filesha512.html filesha512} is a variant of sha512 that hashes the contents of a given file rather than a literal string.
     *
     * @experimental
     */
    static filesha512(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/md5.html md5} computes the MD5 hash of a given string and encodes it with hexadecimal digits.
     *
     * @experimental
     */
    static md5(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/rsadecrypt.html rsadecrypt} decrypts an RSA-encrypted ciphertext, returning the corresponding cleartext.
     *
     * @experimental
     */
    static rsadecrypt(ciphertext: string | IResolvable, privatekey: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/sha1.html sha1} computes the SHA1 hash of a given string and encodes it with hexadecimal digits.
     *
     * @experimental
     */
    static sha1(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/sha256.html sha256} computes the SHA256 hash of a given string and encodes it with hexadecimal digits.
     *
     * @experimental
     */
    static sha256(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/sha512.html sha512} computes the SHA512 hash of a given string and encodes it with hexadecimal digits.
     *
     * @experimental
     */
    static sha512(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/uuid.html uuid} generates a unique identifier string.
     *
     * @experimental
     */
    static uuid(): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/uuidv5.html uuidv5} generates a unique identifier string.
     *
     * @experimental
     */
    static uuidv5(namespace: string | IResolvable, name: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/formatdate.html formatdate} converts a timestamp into a different time format.
     *
     * @experimental
     */
    static formatdate(spec: string | IResolvable, timestamp: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/timeadd.html timeadd} adds a duration to a timestamp, returning a new timestamp.
     *
     * @experimental
     */
    static timeadd(timestamp: string | IResolvable, duration: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/timestamp.html timestamp} returns a UTC timestamp string in RFC 3339 format.
     *
     * @experimental
     */
    static timestamp(): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/base64decode.html base64decode} takes a string containing a Base64 character sequence and returns the original string.
     *
     * @experimental
     */
    static base64decode(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/base64encode.html base64encode} takes a string containing a Base64 character sequence and returns the original string.
     *
     * @experimental
     */
    static base64encode(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/base64gzip.html base64gzip} compresses a string with gzip and then encodes the result in Base64 encoding.
     *
     * @experimental
     */
    static base64gzip(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/csvdecode.html csvdecode} decodes a string containing CSV-formatted data and produces a list of maps representing that data.
     *
     * @experimental
     */
    static csvdecode(value: string | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/jsondecode.html jsondecode} interprets a given string as JSON, returning a representation of the result of decoding that string.
     *
     * @experimental
     */
    static jsondecode(value: string | IResolvable): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/jsonencode.html jsonencode} encodes a given value to a string using JSON syntax.
     *
     * @experimental
     */
    static jsonencode(value: any): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/textdecodebase64.html textdecodebase64} function decodes a string that was previously Base64-encoded, and then interprets the result as characters in a specified character encoding.
     *
     * @experimental
     */
    static textdecodebase64(value: string | IResolvable, encodingName: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/textencodebase64.html textencodebase64}  encodes the unicode characters in a given string using a specified character encoding, returning the result base64 encoded because Terraform language strings are always sequences of unicode characters.
     *
     * @experimental
     */
    static textencodebase64(value: string | IResolvable, encodingName: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/urlencode.html urlencode} applies URL encoding to a given string.
     *
     * @experimental
     */
    static urlencode(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/yamldecode.html yamldecode} parses a string as a subset of YAML, and produces a representation of its value.
     *
     * @experimental
     */
    static yamldecode(value: string | IResolvable): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/yamlencode.html yamlencode} encodes a given value to a string using JSON syntax.
     *
     * @experimental
     */
    static yamlencode(value: any): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/abspath.html abspath} takes a string containing a filesystem path and converts it to an absolute path.
     *
     * @experimental
     */
    static abspath(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/dirname.html dirname} takes a string containing a filesystem path and removes the last portion from it.
     *
     * @experimental
     */
    static dirname(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/pathexpand.html pathexpand} takes a string containing a filesystem path and removes the last portion from it.
     *
     * @experimental
     */
    static pathexpand(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/basename.html basename} takes a string containing a filesystem path and removes all except the last portion from it.
     *
     * @experimental
     */
    static basename(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/file.html file} takes a string containing a filesystem path and removes all except the last portion from it.
     *
     * @experimental
     */
    static file(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/fileexists.html fileexists} determines whether a file exists at a given path.
     *
     * @experimental
     */
    static fileexists(value: string | IResolvable): IResolvable;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/fileset.html fileset} enumerates a set of regular file names given a path and pattern.
     *
     * @experimental
     */
    static fileset(path: string | IResolvable, pattern: string | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/filebase64.html filebase64} reads the contents of a file at the given path and returns them as a base64-encoded string.
     *
     * @experimental
     */
    static filebase64(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/templatefile.html templatefile} reads the file at the given path and renders its content as a template using a supplied set of template variables.
     *
     * @experimental
     */
    static templatefile(path: string | IResolvable, vars: any): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/cidrhost.html cidrhost} calculates a full host IP address for a given host number within a given IP network address prefix.
     *
     * @experimental
     */
    static cidrhost(prefix: string | IResolvable, hostnum: number | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/cidrnetmask.html cidrnetmask} converts an IPv4 address prefix given in CIDR notation into a subnet mask address.
     *
     * @experimental
     */
    static cidrnetmask(prefix: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/cidrsubnet.html cidrsubnet} calculates a subnet address within given IP network address prefix.
     *
     * @experimental
     */
    static cidrsubnet(prefix: string | IResolvable, newbits: number | IResolvable, netnum: number | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/cidrsubnets.html cidrsubnets} calculates a sequence of consecutive IP address ranges within a particular CIDR prefix.
     *
     * @experimental
     */
    static cidrsubnets(prefix: string | IResolvable, newbits: (number | IResolvable)[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/abs.html abs} returns the absolute value of the given number.
     *
     * @experimental
     */
    static abs(value: number | IResolvable): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/ceil.html ceil} returns the closest whole number that is greater than or equal to the given value, which may be a fraction.
     *
     * @experimental
     */
    static ceil(value: number | IResolvable): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/floor.html floor} returns the closest whole number that is less than or equal to the given value, which may be a fraction.
     *
     * @experimental
     */
    static floor(value: number | IResolvable): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/log.html log} returns the logarithm of a given number in a given base.
     *
     * @experimental
     */
    static log(value: number | IResolvable, base: number | IResolvable): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/max.html max} takes one or more numbers and returns the greatest number from the set.
     *
     * @experimental
     */
    static max(values: (number | IResolvable)[]): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/min.html min} takes one or more numbers and returns the smallest number from the set.
     *
     * @experimental
     */
    static min(values: (number | IResolvable)[]): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/parseint.html parseInt} parses the given string as a representation of an integer in the specified base and returns the resulting number. The base must be between 2 and 62 inclusive.
     *
     * @experimental
     */
    static parseInt(value: string | IResolvable, base: number | IResolvable): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/pow.html pow} calculates an exponent, by raising its first argument to the power of the second argument.
     *
     * @experimental
     */
    static pow(value: number | IResolvable, power: number | IResolvable): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/signum.html signum} determines the sign of a number, returning a number between -1 and 1 to represent the sign.
     *
     * @experimental
     */
    static signum(value: number | IResolvable): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/chomp.html chomp} removes newline characters at the end of a string.
     *
     * @experimental
     */
    static chomp(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/format.html format} produces a string by formatting a number of other values according to a specification string.
     *
     * @experimental
     */
    static format(spec: string | IResolvable, values: any[]): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/formatlist.html formatlist} produces a list of strings by formatting a number of other values according to a specification string.
     *
     * @experimental
     */
    static formatlist(spec: string | IResolvable, values: any[]): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/indent.html indent} adds a given number of spaces to the beginnings of all but the first line in a given multi-line string.
     *
     * @experimental
     */
    static indent(indentation: number | IResolvable, value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/join.html join} produces a string by concatenating together all elements of a given list of strings with the given delimiter.
     *
     * @experimental
     */
    static join(separator: string | IResolvable, value: (string | IResolvable)[]): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/lower.html lower} converts all cased letters in the given string to lowercase.
     *
     * @experimental
     */
    static lower(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/regexall.html regexall} applies a regular expression to a string and returns a list of all matches.
     *
     * @experimental
     */
    static regexall(pattern: string | IResolvable, value: string | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/replace.html replace} searches a given string for another given substring, and replaces each occurrence with a given replacement string.
     *
     * @experimental
     */
    static replace(value: string | IResolvable, substring: string | IResolvable, replacement: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/split.html split} produces a list by dividing a given string at all occurrences of a given separator.
     *
     * @experimental
     */
    static split(seperator: string | IResolvable, value: string | IResolvable): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/strrev.html strrev} reverses the characters in a string.
     *
     * @experimental
     */
    static strrev(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/substr.html substr} extracts a substring from a given string by offset and length.
     *
     * @experimental
     */
    static substr(value: string | IResolvable, offset: number | IResolvable, length: number | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/title.html title} converts the first letter of each word in the given string to uppercase.
     *
     * @experimental
     */
    static title(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/trim.html trim} removes the specified characters from the start and end of the given string.
     *
     * @experimental
     */
    static trim(value: string | IResolvable, replacement: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/trimprefix.html trimprefix} removes the specified prefix from the start of the given string.
     *
     * @experimental
     */
    static trimprefix(value: string | IResolvable, prefix: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/trimsuffix.html trimsuffix} removes the specified suffix from the end of the given string.
     *
     * @experimental
     */
    static trimsuffix(value: string | IResolvable, suffix: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/trimspace.html trimspace} removes any space characters from the start and end of the given string.
     *
     * @experimental
     */
    static trimspace(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/upper.html upper} converts all cased letters in the given string to uppercase.
     *
     * @experimental
     */
    static upper(value: string | IResolvable): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/can.html can} evaluates the given expression and returns a boolean value indicating whether the expression produced a result without any errors.
     *
     * @experimental
     */
    static can(expression: any): IResolvable;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/nonsensitive.html nonsensitive} takes a sensitive value and returns a copy of that value with the sensitive marking removed, thereby exposing the sensitive value.
     *
     * @experimental
     */
    static nonsensitive(expression: any): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/sensitive.html sensitive} takes any value and returns a copy of it marked so that Terraform will treat it as sensitive, with the same meaning and behavior as for sensitive input variables.
     *
     * @experimental
     */
    static sensitive(expression: any): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/tobool.html tobool} converts its argument to a boolean value.
     *
     * @experimental
     */
    static tobool(expression: any): IResolvable;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/tolist.html tolist} converts its argument to a list value.
     *
     * @experimental
     */
    static tolist(expression: any): string[];
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/tomap.html tomap} converts its argument to a map value.
     *
     * @experimental
     */
    static tomap(expression: any): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/tonumber.html tonumber} converts its argument to a number value.
     *
     * @experimental
     */
    static tonumber(expression: any): number;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/toset.html toset} converts its argument to a set value.
     *
     * @experimental
     */
    static toset(expression: any): any;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/tostring.html tostring} converts its argument to a string value.
     *
     * @experimental
     */
    static tostring(expression: any): string;
    /**
     * (experimental) {@link https://www.terraform.io/docs/language/functions/try.html try} evaluates all of its argument expressions in turn and returns the result of the first one that does not produce any errors.
     *
     * @experimental
     */
    static try(expression: any[]): any;
    /**
     * (experimental) Use this function to wrap a string and escape it properly for the use in Terraform This is only needed in certain scenarios (e.g., if you have unescaped double quotes in the string).
     *
     * @experimental
     */
    static rawString(str: string): string;
}
