"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformHclModule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_module_1 = require("./terraform-module");
const tokens_1 = require("./tokens");
/**
 * @experimental
 */
class TerraformHclModule extends terraform_module_1.TerraformModule {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        super(scope, id, options);
        this._variables = options.variables;
    }
    /**
     * @experimental
     */
    get variables() {
        return this._variables;
    }
    /**
     * @experimental
     */
    set(variable, value) {
        if (!this._variables) {
            this._variables = {};
        }
        this._variables[variable] = value;
    }
    /**
     * @experimental
     */
    get(output) {
        return tokens_1.Token.asAny(this.interpolationForOutput(output));
    }
    /**
     * @experimental
     */
    getString(output) {
        return tokens_1.Token.asString(this.interpolationForOutput(output));
    }
    /**
     * @experimental
     */
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForOutput(output));
    }
    /**
     * @experimental
     */
    getBoolean(output) {
        return tokens_1.Token.asString(this.interpolationForOutput(output));
    }
    /**
     * @experimental
     */
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForOutput(output));
    }
    /**
     * @experimental
     */
    synthesizeAttributes() {
        return { ...this.variables };
    }
}
exports.TerraformHclModule = TerraformHclModule;
_a = JSII_RTTI_SYMBOL_1;
TerraformHclModule[_a] = { fqn: "cdktf.TerraformHclModule", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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