"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformLocal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
/**
 * @experimental
 */
class TerraformLocal extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, expression) {
        super(scope, id);
        this._expression = expression;
    }
    /**
     * @experimental
     */
    set expression(value) {
        this._expression = value;
    }
    /**
     * @experimental
     */
    get expression() {
        return tokens_1.Token.asAny(tfExpression_1.ref(this.interpolation()));
    }
    /**
     * @experimental
     */
    get asString() {
        return tokens_1.Token.asString(tfExpression_1.ref(this.interpolation()));
    }
    /**
     * @experimental
     */
    get asNumber() {
        return tokens_1.Token.asNumber(tfExpression_1.ref(this.interpolation()));
    }
    /**
     * @experimental
     */
    get asList() {
        return tokens_1.Token.asList(tfExpression_1.ref(this.interpolation()));
    }
    /**
     * @experimental
     */
    get asBoolean() {
        return tfExpression_1.ref(this.interpolation());
    }
    interpolation() {
        return `local.${this.friendlyUniqueId}`;
    }
    /**
     * @experimental
     */
    get fqn() {
        return `local.${this.friendlyUniqueId}`;
    }
    /**
     * @experimental
     */
    toTerraform() {
        return {
            locals: {
                [this.friendlyUniqueId]: this._expression,
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                local: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformLocal = TerraformLocal;
_a = JSII_RTTI_SYMBOL_1;
TerraformLocal[_a] = { fqn: "cdktf.TerraformLocal", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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