import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { ITerraformDependable } from "./terraform-dependable";
/**
 * @experimental
 */
export interface TerraformModuleOptions {
    /**
     * @experimental
     */
    readonly source: string;
    /**
     * @experimental
     */
    readonly version?: string;
    /**
     * @experimental
     */
    readonly providers?: (TerraformProvider | TerraformModuleProvider)[];
    /**
     * @experimental
     */
    readonly dependsOn?: ITerraformDependable[];
}
/**
 * @experimental
 */
export interface TerraformModuleProvider {
    /**
     * @experimental
     */
    readonly provider: TerraformProvider;
    /**
     * @experimental
     */
    readonly moduleAlias: string;
}
/**
 * @experimental
 */
export declare abstract class TerraformModule extends TerraformElement implements ITerraformDependable {
    /**
     * @experimental
     */
    readonly source: string;
    /**
     * @experimental
     */
    readonly version?: string;
    private _providers?;
    /**
     * @experimental
     */
    dependsOn?: string[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, options: TerraformModuleOptions);
    /**
     * @experimental
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    /**
     * @experimental
     */
    interpolationForOutput(moduleOutput: string): string;
    /**
     * @experimental
     */
    get fqn(): string;
    /**
     * @experimental
     */
    get providers(): (TerraformProvider | TerraformModuleProvider)[] | undefined;
    /**
     * @experimental
     */
    addProvider(provider: TerraformProvider | TerraformModuleProvider): void;
    /**
     * @experimental
     */
    toTerraform(): any;
    /**
     * @experimental
     */
    toMetadata(): any;
    private validateIfProvidersHaveUniqueKeys;
}
