"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformModule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const terraform_provider_1 = require("./terraform-provider");
const util_1 = require("./util");
const tokens_1 = require("./tokens");
const path = require("path");
const tfExpression_1 = require("./tfExpression");
const token_map_1 = require("./tokens/private/token-map");
/**
 * @experimental
 */
class TerraformModule extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        super(scope, id);
        if (options.source.startsWith("./") || options.source.startsWith("../")) {
            this.source = path.join("../../..", options.source);
        }
        else {
            this.source = options.source;
        }
        this.version = options.version;
        this._providers = options.providers;
        this.validateIfProvidersHaveUniqueKeys();
        if (Array.isArray(options.dependsOn)) {
            this.dependsOn = options.dependsOn.map((dependency) => dependency.fqn);
        }
    }
    // jsii can't handle abstract classes?
    /**
     * @experimental
     */
    synthesizeAttributes() {
        return {};
    }
    /**
     * @experimental
     */
    interpolationForOutput(moduleOutput) {
        return token_map_1.TokenMap.instance().registerString(tfExpression_1.ref(`module.${this.friendlyUniqueId}.${moduleOutput}`));
    }
    /**
     * @experimental
     */
    get fqn() {
        return tokens_1.Token.asString(`module.${this.friendlyUniqueId}`);
    }
    /**
     * @experimental
     */
    get providers() {
        return this._providers;
    }
    /**
     * @experimental
     */
    addProvider(provider) {
        if (!this._providers) {
            this._providers = [];
        }
        this._providers.push(provider);
        this.validateIfProvidersHaveUniqueKeys();
    }
    /**
     * @experimental
     */
    toTerraform() {
        var _b;
        const attributes = util_1.deepMerge({
            ...this.synthesizeAttributes(),
            source: this.source,
            version: this.version,
            providers: (_b = this._providers) === null || _b === void 0 ? void 0 : _b.reduce((a, p) => {
                if (p instanceof terraform_provider_1.TerraformProvider) {
                    return { ...a, [p.terraformResourceType]: p.fqn };
                }
                else {
                    return {
                        ...a,
                        [`${p.provider.terraformResourceType}.${p.moduleAlias}`]: p.provider.fqn,
                    };
                }
            }, {}),
            depends_on: this.dependsOn,
        }, this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            module: {
                [this.friendlyUniqueId]: attributes,
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [`module.${this.source}`]: Object.keys(this.rawOverrides),
            },
        };
    }
    validateIfProvidersHaveUniqueKeys() {
        var _b;
        const moduleAliases = (_b = this._providers) === null || _b === void 0 ? void 0 : _b.map((p) => {
            if (p instanceof terraform_provider_1.TerraformProvider) {
                return p.terraformResourceType;
            }
            else {
                return `${p.provider.terraformResourceType}.${p.moduleAlias}`;
            }
        });
        const uniqueModuleAliases = new Set();
        moduleAliases === null || moduleAliases === void 0 ? void 0 : moduleAliases.forEach((alias) => {
            if (uniqueModuleAliases.has(alias)) {
                throw new Error(`Error: Multiple providers have the same alias: "${alias}"`);
            }
            uniqueModuleAliases.add(alias);
        });
    }
}
exports.TerraformModule = TerraformModule;
_a = JSII_RTTI_SYMBOL_1;
TerraformModule[_a] = { fqn: "cdktf.TerraformModule", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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