import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { ITerraformDependable } from "./terraform-dependable";
import { Expression } from ".";
import { ITerraformAddressable } from "./terraform-addressable";
/**
 * @experimental
 */
export interface TerraformOutputConfig {
    /**
     * @experimental
     */
    readonly value: Expression | ITerraformDependable;
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * @experimental
     */
    readonly sensitive?: boolean;
    /**
     * @experimental
     */
    readonly dependsOn?: ITerraformDependable[];
    /**
     * (experimental) If set to true the synthesized Terraform Output will be named after the `id` passed to the constructor instead of the default (TerraformOutput.friendlyUniqueId).
     *
     * @default false
     * @experimental
     */
    readonly staticId?: boolean;
}
/**
 * @experimental
 */
export declare class TerraformOutput extends TerraformElement {
    /**
     * @experimental
     */
    value: Expression | ITerraformAddressable;
    /**
     * @experimental
     */
    description?: string;
    /**
     * @experimental
     */
    sensitive?: boolean;
    /**
     * @experimental
     */
    dependsOn?: ITerraformDependable[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, config: TerraformOutputConfig);
    /**
     * @experimental
     */
    set staticId(staticId: boolean);
    /**
     * @experimental
     */
    get staticId(): boolean;
    private isITerraformAddressable;
    private synthesizeValue;
    /**
     * @experimental
     */
    protected synthesizeAttributes(): {
        [key: string]: any;
    };
    /**
     * @experimental
     */
    toTerraform(): any;
    /**
     * @experimental
     */
    toMetadata(): any;
}
