"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformOutput = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const _1 = require(".");
const util_2 = require("util");
/**
 * @experimental
 */
class TerraformOutput extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, config) {
        super(scope, id);
        this.value = config.value;
        this.description = config.description;
        this.sensitive = config.sensitive;
        this.dependsOn = config.dependsOn;
        this.staticId = config.staticId || false;
    }
    /**
     * @experimental
     */
    set staticId(staticId) {
        if (staticId)
            this.overrideLogicalId(this.node.id);
        else
            this.resetOverrideLogicalId();
    }
    /**
     * @experimental
     */
    get staticId() {
        return this.friendlyUniqueId === this.node.id;
    }
    isITerraformAddressable(object) {
        return (object &&
            typeof object === "object" &&
            !util_2.isArray(object) &&
            "fqn" in object);
    }
    synthesizeValue(arg) {
        if (_1.Tokenization.isResolvable(arg)) {
            return arg;
        }
        if (this.isITerraformAddressable(arg)) {
            return _1.ref(arg.fqn);
        }
        if (Array.isArray(arg)) {
            return arg.map((innerArg) => this.synthesizeValue(innerArg));
        }
        if (typeof arg === "object") {
            return Object.keys(arg).reduce((result, key) => {
                result[key] = this.synthesizeValue(arg[key]);
                return result;
            }, {});
        }
        return arg;
    }
    /**
     * @experimental
     */
    synthesizeAttributes() {
        var _b;
        return {
            value: this.synthesizeValue(this.value),
            description: this.description,
            sensitive: this.sensitive,
            depends_on: (_b = this.dependsOn) === null || _b === void 0 ? void 0 : _b.map((resource) => `\${${resource.fqn}}`),
        };
    }
    /**
     * @experimental
     */
    toTerraform() {
        return {
            output: {
                [this.friendlyUniqueId]: util_1.deepMerge(this.synthesizeAttributes(), this.rawOverrides),
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                output: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformOutput = TerraformOutput;
_a = JSII_RTTI_SYMBOL_1;
TerraformOutput[_a] = { fqn: "cdktf.TerraformOutput", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVycmFmb3JtLW91dHB1dC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlcnJhZm9ybS1vdXRwdXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSwyREFBdUQ7QUFDdkQsaUNBQW1DO0FBRW5DLHdCQUFrRDtBQUNsRCwrQkFBK0I7Ozs7QUFZL0IsTUFBYSxlQUFnQixTQUFRLG9DQUFnQjs7OztJQU1uRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQTZCO1FBQ3JFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDO1FBQzFCLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN0QyxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDbEMsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLFFBQVEsSUFBSSxLQUFLLENBQUM7SUFDM0MsQ0FBQzs7OztJQUVELElBQVcsUUFBUSxDQUFDLFFBQWlCO1FBQ25DLElBQUksUUFBUTtZQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDOztZQUM5QyxJQUFJLENBQUMsc0JBQXNCLEVBQUUsQ0FBQztJQUNyQyxDQUFDOzs7O0lBRUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixLQUFLLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDO0lBQ2hELENBQUM7SUFFTyx1QkFBdUIsQ0FDN0IsTUFBVztRQUVYLE9BQU8sQ0FDTCxNQUFNO1lBQ04sT0FBTyxNQUFNLEtBQUssUUFBUTtZQUMxQixDQUFDLGNBQU8sQ0FBQyxNQUFNLENBQUM7WUFDaEIsS0FBSyxJQUFJLE1BQU0sQ0FDaEIsQ0FBQztJQUNKLENBQUM7SUFFTyxlQUFlLENBQUMsR0FBUTtRQUM5QixJQUFJLGVBQVksQ0FBQyxZQUFZLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFDbEMsT0FBTyxHQUFHLENBQUM7U0FDWjtRQUVELElBQUksSUFBSSxDQUFDLHVCQUF1QixDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ3JDLE9BQU8sTUFBRyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUNyQjtRQUVELElBQUksS0FBSyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUN0QixPQUFPLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztTQUM5RDtRQUVELElBQUksT0FBTyxHQUFHLEtBQUssUUFBUSxFQUFFO1lBQzNCLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLEVBQUUsR0FBRyxFQUFFLEVBQUU7Z0JBQzdDLE1BQU0sQ0FBQyxHQUFHLENBQUMsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO2dCQUM3QyxPQUFPLE1BQU0sQ0FBQztZQUNoQixDQUFDLEVBQUUsRUFBK0IsQ0FBQyxDQUFDO1NBQ3JDO1FBRUQsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDOzs7O0lBRVMsb0JBQW9COztRQUM1QixPQUFPO1lBQ0wsS0FBSyxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUN2QyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFVBQVUsUUFBRSxJQUFJLENBQUMsU0FBUywwQ0FBRSxHQUFHLENBQUMsQ0FBQyxRQUFRLEVBQUUsRUFBRSxDQUFDLE1BQU0sUUFBUSxDQUFDLEdBQUcsR0FBRyxDQUFDO1NBQ3JFLENBQUM7SUFDSixDQUFDOzs7O0lBRU0sV0FBVztRQUNoQixPQUFPO1lBQ0wsTUFBTSxFQUFFO2dCQUNOLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEVBQUUsZ0JBQVMsQ0FDaEMsSUFBSSxDQUFDLG9CQUFvQixFQUFFLEVBQzNCLElBQUksQ0FBQyxZQUFZLENBQ2xCO2FBQ0Y7U0FDRixDQUFDO0lBQ0osQ0FBQzs7OztJQUVNLFVBQVU7UUFDZixJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsTUFBTSxFQUFFO1lBQzFDLE9BQU8sRUFBRSxDQUFDO1NBQ1g7UUFFRCxPQUFPO1lBQ0wsU0FBUyxFQUFFO2dCQUNULE1BQU0sRUFBRSxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7YUFDdkM7U0FDRixDQUFDO0lBQ0osQ0FBQzs7QUF6RkgsMENBMEZDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IFRlcnJhZm9ybUVsZW1lbnQgfSBmcm9tIFwiLi90ZXJyYWZvcm0tZWxlbWVudFwiO1xuaW1wb3J0IHsgZGVlcE1lcmdlIH0gZnJvbSBcIi4vdXRpbFwiO1xuaW1wb3J0IHsgSVRlcnJhZm9ybURlcGVuZGFibGUgfSBmcm9tIFwiLi90ZXJyYWZvcm0tZGVwZW5kYWJsZVwiO1xuaW1wb3J0IHsgRXhwcmVzc2lvbiwgcmVmLCBUb2tlbml6YXRpb24gfSBmcm9tIFwiLlwiO1xuaW1wb3J0IHsgaXNBcnJheSB9IGZyb20gXCJ1dGlsXCI7XG5pbXBvcnQgeyBJVGVycmFmb3JtQWRkcmVzc2FibGUgfSBmcm9tIFwiLi90ZXJyYWZvcm0tYWRkcmVzc2FibGVcIjtcblxuZXhwb3J0IGludGVyZmFjZSBUZXJyYWZvcm1PdXRwdXRDb25maWcge1xuICByZWFkb25seSB2YWx1ZTogRXhwcmVzc2lvbiB8IElUZXJyYWZvcm1EZXBlbmRhYmxlO1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcbiAgcmVhZG9ubHkgc2Vuc2l0aXZlPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgZGVwZW5kc09uPzogSVRlcnJhZm9ybURlcGVuZGFibGVbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzdGF0aWNJZD86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBjbGFzcyBUZXJyYWZvcm1PdXRwdXQgZXh0ZW5kcyBUZXJyYWZvcm1FbGVtZW50IHtcbiAgcHVibGljIHZhbHVlOiBFeHByZXNzaW9uIHwgSVRlcnJhZm9ybUFkZHJlc3NhYmxlO1xuICBwdWJsaWMgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gIHB1YmxpYyBzZW5zaXRpdmU/OiBib29sZWFuO1xuICBwdWJsaWMgZGVwZW5kc09uPzogSVRlcnJhZm9ybURlcGVuZGFibGVbXTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IFRlcnJhZm9ybU91dHB1dENvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnZhbHVlID0gY29uZmlnLnZhbHVlO1xuICAgIHRoaXMuZGVzY3JpcHRpb24gPSBjb25maWcuZGVzY3JpcHRpb247XG4gICAgdGhpcy5zZW5zaXRpdmUgPSBjb25maWcuc2Vuc2l0aXZlO1xuICAgIHRoaXMuZGVwZW5kc09uID0gY29uZmlnLmRlcGVuZHNPbjtcbiAgICB0aGlzLnN0YXRpY0lkID0gY29uZmlnLnN0YXRpY0lkIHx8IGZhbHNlO1xuICB9XG5cbiAgcHVibGljIHNldCBzdGF0aWNJZChzdGF0aWNJZDogYm9vbGVhbikge1xuICAgIGlmIChzdGF0aWNJZCkgdGhpcy5vdmVycmlkZUxvZ2ljYWxJZCh0aGlzLm5vZGUuaWQpO1xuICAgIGVsc2UgdGhpcy5yZXNldE92ZXJyaWRlTG9naWNhbElkKCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IHN0YXRpY0lkKCk6IGJvb2xlYW4ge1xuICAgIHJldHVybiB0aGlzLmZyaWVuZGx5VW5pcXVlSWQgPT09IHRoaXMubm9kZS5pZDtcbiAgfVxuXG4gIHByaXZhdGUgaXNJVGVycmFmb3JtQWRkcmVzc2FibGUoXG4gICAgb2JqZWN0OiBhbnlcbiAgKTogb2JqZWN0IGlzIElUZXJyYWZvcm1BZGRyZXNzYWJsZSB7XG4gICAgcmV0dXJuIChcbiAgICAgIG9iamVjdCAmJlxuICAgICAgdHlwZW9mIG9iamVjdCA9PT0gXCJvYmplY3RcIiAmJlxuICAgICAgIWlzQXJyYXkob2JqZWN0KSAmJlxuICAgICAgXCJmcW5cIiBpbiBvYmplY3RcbiAgICApO1xuICB9XG5cbiAgcHJpdmF0ZSBzeW50aGVzaXplVmFsdWUoYXJnOiBhbnkpOiBhbnkge1xuICAgIGlmIChUb2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKGFyZykpIHtcbiAgICAgIHJldHVybiBhcmc7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuaXNJVGVycmFmb3JtQWRkcmVzc2FibGUoYXJnKSkge1xuICAgICAgcmV0dXJuIHJlZihhcmcuZnFuKTtcbiAgICB9XG5cbiAgICBpZiAoQXJyYXkuaXNBcnJheShhcmcpKSB7XG4gICAgICByZXR1cm4gYXJnLm1hcCgoaW5uZXJBcmcpID0+IHRoaXMuc3ludGhlc2l6ZVZhbHVlKGlubmVyQXJnKSk7XG4gICAgfVxuXG4gICAgaWYgKHR5cGVvZiBhcmcgPT09IFwib2JqZWN0XCIpIHtcbiAgICAgIHJldHVybiBPYmplY3Qua2V5cyhhcmcpLnJlZHVjZSgocmVzdWx0LCBrZXkpID0+IHtcbiAgICAgICAgcmVzdWx0W2tleV0gPSB0aGlzLnN5bnRoZXNpemVWYWx1ZShhcmdba2V5XSk7XG4gICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgICB9LCB7fSBhcyB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4gYXJnO1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICB2YWx1ZTogdGhpcy5zeW50aGVzaXplVmFsdWUodGhpcy52YWx1ZSksXG4gICAgICBkZXNjcmlwdGlvbjogdGhpcy5kZXNjcmlwdGlvbixcbiAgICAgIHNlbnNpdGl2ZTogdGhpcy5zZW5zaXRpdmUsXG4gICAgICBkZXBlbmRzX29uOiB0aGlzLmRlcGVuZHNPbj8ubWFwKChyZXNvdXJjZSkgPT4gYFxcJHske3Jlc291cmNlLmZxbn19YCksXG4gICAgfTtcbiAgfVxuXG4gIHB1YmxpYyB0b1RlcnJhZm9ybSgpOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICBvdXRwdXQ6IHtcbiAgICAgICAgW3RoaXMuZnJpZW5kbHlVbmlxdWVJZF06IGRlZXBNZXJnZShcbiAgICAgICAgICB0aGlzLnN5bnRoZXNpemVBdHRyaWJ1dGVzKCksXG4gICAgICAgICAgdGhpcy5yYXdPdmVycmlkZXNcbiAgICAgICAgKSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIHB1YmxpYyB0b01ldGFkYXRhKCk6IGFueSB7XG4gICAgaWYgKCFPYmplY3Qua2V5cyh0aGlzLnJhd092ZXJyaWRlcykubGVuZ3RoKSB7XG4gICAgICByZXR1cm4ge307XG4gICAgfVxuXG4gICAgcmV0dXJuIHtcbiAgICAgIG92ZXJyaWRlczoge1xuICAgICAgICBvdXRwdXQ6IE9iamVjdC5rZXlzKHRoaXMucmF3T3ZlcnJpZGVzKSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19