"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
/**
 * @experimental
 */
class TerraformProvider extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, config) {
        super(scope, id);
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        this.terraformProviderSource = config.terraformProviderSource;
    }
    /**
     * @experimental
     */
    get alias() {
        // This is always* being overriden currently
        return undefined;
    }
    /**
     * @experimental
     */
    set alias(_value) {
        // This is always* being overriden currently
    }
    /**
     * @experimental
     */
    get fqn() {
        return this.alias !== undefined
            ? tokens_1.Token.asString(`${this.terraformResourceType}.${this.alias}`)
            : tokens_1.Token.asString(`${this.terraformResourceType}`);
    }
    /**
     * @experimental
     */
    get metaAttributes() {
        return this.alias !== undefined ? { alias: this.alias } : {};
    }
    // jsii can't handle abstract classes?
    /**
     * @experimental
     */
    synthesizeAttributes() {
        return {};
    }
    /**
     * (experimental) Adds this resource to the terraform JSON output.
     *
     * @experimental
     */
    toTerraform() {
        var _b;
        return {
            terraform: {
                required_providers: {
                    [this.terraformResourceType]: {
                        version: (_b = this.terraformGeneratorMetadata) === null || _b === void 0 ? void 0 : _b.providerVersionConstraint,
                        source: this.terraformProviderSource,
                    },
                },
            },
            provider: {
                [this.terraformResourceType]: [
                    util_1.deepMerge(util_1.keysToSnakeCase(this.synthesizeAttributes()), this.rawOverrides, this.metaAttributes),
                ],
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformProvider = TerraformProvider;
_a = JSII_RTTI_SYMBOL_1;
TerraformProvider[_a] = { fqn: "cdktf.TerraformProvider", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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