"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformRemoteState = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const tokens_1 = require("./tokens");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
/**
 * @experimental
 */
class TerraformRemoteState extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, backend, config) {
        super(scope, id);
        this.backend = backend;
        this.config = config;
    }
    /**
     * @experimental
     */
    getString(output) {
        return tokens_1.Token.asString(this.interpolationForAttribute(output));
    }
    /**
     * @experimental
     */
    getNumber(output) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(output));
    }
    /**
     * @experimental
     */
    getList(output) {
        return tokens_1.Token.asList(this.interpolationForAttribute(output));
    }
    /**
     * @experimental
     */
    getBoolean(output) {
        return tokens_1.Token.asString(this.interpolationForAttribute(output));
    }
    /**
     * @experimental
     */
    get(output) {
        return tokens_1.Token.asAny(this.interpolationForAttribute(output));
    }
    interpolationForAttribute(terraformAttribute) {
        return tfExpression_1.ref(`data.terraform_remote_state.${this.friendlyUniqueId}.outputs.${terraformAttribute}`);
    }
    /**
     * @experimental
     */
    get fqn() {
        return `data.terraform_remote_state.${this.friendlyUniqueId}`;
    }
    extractConfig() {
        const configObj = util_1.keysToSnakeCase({ ...this.config });
        delete configObj.workspace;
        delete configObj.defaults;
        return configObj;
    }
    /**
     * (experimental) Adds this resource to the terraform JSON output.
     *
     * @experimental
     */
    toTerraform() {
        return {
            data: {
                terraform_remote_state: {
                    [this.friendlyUniqueId]: util_1.deepMerge({
                        backend: this.backend,
                        workspace: this.config.workspace,
                        defaults: this.config.defaults,
                        config: this.extractConfig(),
                    }, this.rawOverrides),
                },
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                terraform_remote_state: Object.keys(this.rawOverrides),
            },
        };
    }
}
exports.TerraformRemoteState = TerraformRemoteState;
_a = JSII_RTTI_SYMBOL_1;
TerraformRemoteState[_a] = { fqn: "cdktf.TerraformRemoteState", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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