import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { ITerraformDependable } from "./terraform-dependable";
import { IResolvable } from "./tokens/resolvable";
/**
 * @experimental
 */
export interface ITerraformResource {
    /**
     * @experimental
     */
    readonly terraformResourceType: string;
    /**
     * @experimental
     */
    readonly fqn: string;
    /**
     * @experimental
     */
    readonly friendlyUniqueId: string;
    /**
     * @experimental
     */
    dependsOn?: string[];
    /**
     * @experimental
     */
    count?: number | IResolvable;
    /**
     * @experimental
     */
    provider?: TerraformProvider;
    /**
     * @experimental
     */
    lifecycle?: TerraformResourceLifecycle;
    /**
     * @experimental
     */
    interpolationForAttribute(terraformAttribute: string): IResolvable;
}
/**
 * @experimental
 */
export interface TerraformResourceLifecycle {
    /**
     * @experimental
     */
    readonly createBeforeDestroy?: boolean;
    /**
     * @experimental
     */
    readonly preventDestroy?: boolean;
    /**
     * @experimental
     */
    readonly ignoreChanges?: string[];
}
/**
 * @experimental
 */
export interface TerraformMetaArguments {
    /**
     * @experimental
     */
    readonly dependsOn?: ITerraformDependable[];
    /**
     * @experimental
     */
    readonly count?: number | IResolvable;
    /**
     * @experimental
     */
    readonly provider?: TerraformProvider;
    /**
     * @experimental
     */
    readonly lifecycle?: TerraformResourceLifecycle;
}
/**
 * @experimental
 */
export interface TerraformProviderGeneratorMetadata {
    /**
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    readonly providerVersionConstraint?: string;
}
/**
 * @experimental
 */
export interface TerraformResourceConfig extends TerraformMetaArguments {
    /**
     * @experimental
     */
    readonly terraformResourceType: string;
    /**
     * @experimental
     */
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
}
/**
 * @experimental
 */
export declare class TerraformResource extends TerraformElement implements ITerraformResource, ITerraformDependable {
    /**
     * @experimental
     */
    readonly terraformResourceType: string;
    /**
     * @experimental
     */
    readonly terraformGeneratorMetadata?: TerraformProviderGeneratorMetadata;
    /**
     * @experimental
     */
    dependsOn?: string[];
    /**
     * @experimental
     */
    count?: number | IResolvable;
    /**
     * @experimental
     */
    provider?: TerraformProvider;
    /**
     * @experimental
     */
    lifecycle?: TerraformResourceLifecycle;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, config: TerraformResourceConfig);
    /**
     * @experimental
     */
    getStringAttribute(terraformAttribute: string): string;
    /**
     * @experimental
     */
    getNumberAttribute(terraformAttribute: string): number;
    /**
     * @experimental
     */
    getListAttribute(terraformAttribute: string): string[];
    /**
     * @experimental
     */
    getBooleanAttribute(terraformAttribute: string): IResolvable;
    /**
     * @experimental
     */
    get fqn(): string;
    /**
     * @experimental
     */
    get terraformMetaArguments(): {
        [name: string]: any;
    };
    /**
     * @experimental
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    /**
     * (experimental) Adds this resource to the terraform JSON output.
     *
     * @experimental
     */
    toTerraform(): any;
    /**
     * @experimental
     */
    toMetadata(): any;
    /**
     * @experimental
     */
    interpolationForAttribute(terraformAttribute: string): IResolvable;
}
