"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const tokens_1 = require("./tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tfExpression_1 = require("./tfExpression");
/**
 * @experimental
 */
class TerraformResource extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, config) {
        super(scope, id);
        this.terraformResourceType = config.terraformResourceType;
        this.terraformGeneratorMetadata = config.terraformGeneratorMetadata;
        if (Array.isArray(config.dependsOn)) {
            this.dependsOn = config.dependsOn.map((dependency) => dependency.fqn);
        }
        this.count = config.count;
        this.provider = config.provider;
        this.lifecycle = config.lifecycle;
    }
    /**
     * @experimental
     */
    getStringAttribute(terraformAttribute) {
        return tokens_1.Token.asString(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getNumberAttribute(terraformAttribute) {
        return tokens_1.Token.asNumber(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getListAttribute(terraformAttribute) {
        return tokens_1.Token.asList(this.interpolationForAttribute(terraformAttribute));
    }
    /**
     * @experimental
     */
    getBooleanAttribute(terraformAttribute) {
        return this.interpolationForAttribute(terraformAttribute);
    }
    /**
     * @experimental
     */
    get fqn() {
        return tokens_1.Token.asString(`${this.terraformResourceType}.${this.friendlyUniqueId}`);
    }
    /**
     * @experimental
     */
    get terraformMetaArguments() {
        var _b;
        return {
            dependsOn: this.dependsOn,
            count: this.count,
            provider: (_b = this.provider) === null || _b === void 0 ? void 0 : _b.fqn,
            lifecycle: this.lifecycle,
        };
    }
    // jsii can't handle abstract classes?
    /**
     * @experimental
     */
    synthesizeAttributes() {
        return {};
    }
    /**
     * (experimental) Adds this resource to the terraform JSON output.
     *
     * @experimental
     */
    toTerraform() {
        const attributes = util_1.deepMerge(this.synthesizeAttributes(), util_1.keysToSnakeCase(this.terraformMetaArguments), this.rawOverrides);
        attributes["//"] = this.constructNodeMetadata;
        return {
            resource: {
                [this.terraformResourceType]: {
                    [this.friendlyUniqueId]: attributes,
                },
            },
        };
    }
    /**
     * @experimental
     */
    toMetadata() {
        if (!Object.keys(this.rawOverrides).length) {
            return {};
        }
        return {
            overrides: {
                [this.terraformResourceType]: Object.keys(this.rawOverrides),
            },
        };
    }
    /**
     * @experimental
     */
    interpolationForAttribute(terraformAttribute) {
        return tfExpression_1.ref(`${this.terraformResourceType}.${this.friendlyUniqueId}.${terraformAttribute}`);
    }
}
exports.TerraformResource = TerraformResource;
_a = JSII_RTTI_SYMBOL_1;
TerraformResource[_a] = { fqn: "cdktf.TerraformResource", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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