import { Construct, IConstruct, Node } from "constructs";
import { TerraformElement } from "./terraform-element";
import { TerraformProvider } from "./terraform-provider";
import { IStackSynthesizer } from "./synthesize/types";
/**
 * @experimental
 */
export interface TerraformStackMetadata {
    /**
     * @experimental
     */
    readonly stackName: string;
    /**
     * @experimental
     */
    readonly version: string;
    /**
     * @experimental
     */
    readonly backend: string;
}
/**
 * @experimental
 */
export declare class TerraformStack extends Construct {
    private readonly rawOverrides;
    private readonly cdktfVersion;
    /**
     * @experimental
     */
    synthesizer: IStackSynthesizer;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string);
    /**
     * @experimental
     */
    static isStack(x: any): x is TerraformStack;
    /**
     * @experimental
     */
    static of(construct: IConstruct): TerraformStack;
    /**
     * @experimental
     */
    addOverride(path: string, value: any): void;
    /**
     * @experimental
     */
    getLogicalId(tfElement: TerraformElement | Node): string;
    /**
     * (experimental) Returns the naming scheme used to allocate logical IDs.
     *
     * By default, uses
     * the `HashedAddressingScheme` but this method can be overridden to customize
     * this behavior.
     *
     * @param tfElement The element for which the logical ID is allocated.
     * @experimental
     */
    protected allocateLogicalId(tfElement: TerraformElement | Node): string;
    /**
     * @experimental
     */
    allProviders(): TerraformProvider[];
    /**
     * @experimental
     */
    toTerraform(): any;
}
