"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const _tokens_1 = require("./_tokens");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const terraform_provider_1 = require("./terraform-provider");
const features_1 = require("./features");
const unique_1 = require("./private/unique");
const synthesizer_1 = require("./synthesize/synthesizer");
const STACK_SYMBOL = Symbol.for("cdktf/TerraformStack");
const validations_1 = require("./validations");
const app_1 = require("./app");
const terraform_backend_1 = require("./terraform-backend");
/**
 * @experimental
 */
class TerraformStack extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id) {
        super(scope, id);
        this.rawOverrides = {};
        this.cdktfVersion = this.node.tryGetContext("cdktfVersion");
        this.synthesizer = new synthesizer_1.StackSynthesizer(this, process.env.CDKTF_CONTINUE_SYNTH_ON_ERROR_ANNOTATIONS !== undefined);
        Object.defineProperty(this, STACK_SYMBOL, { value: true });
        this.node.addValidation(new validations_1.ValidateProviderPresence(this));
    }
    /**
     * @experimental
     */
    static isStack(x) {
        return x !== null && typeof x === "object" && STACK_SYMBOL in x;
    }
    /**
     * @experimental
     */
    static of(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (TerraformStack.isStack(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                let hint = "";
                if (construct.node.scope === c &&
                    c instanceof app_1.App &&
                    construct instanceof terraform_backend_1.TerraformBackend) {
                    // the scope of the originally passed construct equals the construct c
                    // which has no scope (i.e. has no parent construct) and c is an App
                    // and our construct is a Backend
                    hint = `. You seem to have passed your root App as scope to a TerraformBackend construct. Pass a stack as scope to your backend instead.`;
                }
                throw new Error(`No stack could be identified for the construct at path '${construct.node.path}'${hint}`);
            }
            return _lookup(node.scope);
        }
    }
    /**
     * @experimental
     */
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    /**
     * @experimental
     */
    getLogicalId(tfElement) {
        // wrap the allocation for future renaming support
        return this.allocateLogicalId(tfElement);
    }
    /**
     * (experimental) Returns the naming scheme used to allocate logical IDs.
     *
     * By default, uses
     * the `HashedAddressingScheme` but this method can be overridden to customize
     * this behavior.
     *
     * @param tfElement The element for which the logical ID is allocated.
     * @experimental
     */
    allocateLogicalId(tfElement) {
        const node = tfElement instanceof terraform_element_1.TerraformElement ? tfElement.node : tfElement;
        const stack = tfElement instanceof terraform_element_1.TerraformElement ? tfElement.cdktfStack : this;
        let stackIndex;
        if (node.tryGetContext(features_1.EXCLUDE_STACK_ID_FROM_LOGICAL_IDS)) {
            stackIndex = node.scopes.indexOf(stack);
        }
        else {
            stackIndex = 0;
        }
        const components = node.scopes.slice(stackIndex + 1).map((c) => c.node.id);
        return components.length > 0
            ? unique_1.makeUniqueId(components, node.tryGetContext(features_1.ALLOW_SEP_CHARS_IN_LOGICAL_IDS))
            : "";
    }
    /**
     * @experimental
     */
    allProviders() {
        const providers = [];
        const visit = async (node) => {
            if (node instanceof terraform_provider_1.TerraformProvider) {
                providers.push(node);
            }
            for (const child of node.node.children) {
                visit(child);
            }
        };
        visit(this);
        return _tokens_1.resolve(this, providers);
    }
    /**
     * @experimental
     */
    toTerraform() {
        const tf = {};
        const metadata = {
            version: this.cdktfVersion,
            stackName: this.node.id,
            backend: "local",
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { stack: Object.keys(this.rawOverrides) } }
                : {}),
        };
        const elements = terraformElements(this);
        const metadatas = elements.map((e) => _tokens_1.resolve(this, e.toMetadata()));
        for (const meta of metadatas) {
            util_1.deepMerge(metadata, meta);
        }
        tf["//"] = { metadata };
        const fragments = elements.map((e) => _tokens_1.resolve(this, e.toTerraform()));
        for (const fragment of fragments) {
            util_1.deepMerge(tf, fragment);
        }
        util_1.deepMerge(tf, this.rawOverrides);
        return _tokens_1.resolve(this, tf);
    }
}
exports.TerraformStack = TerraformStack;
_a = JSII_RTTI_SYMBOL_1;
TerraformStack[_a] = { fqn: "cdktf.TerraformStack", version: "0.9.0-pre.6" };
function terraformElements(node, into = []) {
    if (node instanceof terraform_element_1.TerraformElement) {
        into.push(node);
    }
    for (const child of node.node.children) {
        // Don't recurse into a substack
        if (TerraformStack.isStack(child)) {
            continue;
        }
        terraformElements(child, into);
    }
    return into;
}
//# sourceMappingURL=data:application/json;base64,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