import { Construct } from "constructs";
import { TerraformElement } from "./terraform-element";
import { ITerraformAddressable } from "./terraform-addressable";
/**
 * @experimental
 */
export declare abstract class VariableType {
    /**
     * @experimental
     */
    static readonly STRING = "string";
    /**
     * @experimental
     */
    static readonly NUMBER = "number";
    /**
     * @experimental
     */
    static readonly BOOL = "bool";
    /**
     * @experimental
     */
    static readonly ANY = "any";
    /**
     * @experimental
     */
    static readonly LIST = "list";
    /**
     * @experimental
     */
    static readonly MAP = "map";
    /**
     * @experimental
     */
    static readonly SET = "set";
    /**
     * @experimental
     */
    static readonly LIST_STRING = "list(string)";
    /**
     * @experimental
     */
    static readonly LIST_NUMBER = "list(number)";
    /**
     * @experimental
     */
    static readonly LIST_BOOL = "list(bool)";
    /**
     * @experimental
     */
    static readonly MAP_STRING = "map(string)";
    /**
     * @experimental
     */
    static readonly MAP_NUMBER = "map(number)";
    /**
     * @experimental
     */
    static readonly MAP_BOOL = "map(bool)";
    /**
     * @experimental
     */
    static readonly SET_STRING = "set(string)";
    /**
     * @experimental
     */
    static readonly SET_NUMBER = "set(number)";
    /**
     * @experimental
     */
    static readonly SET_BOOL = "set(bool)";
    /**
     * @experimental
     */
    static list(type: string): string;
    /**
     * @experimental
     */
    static map(type: string): string;
    /**
     * @experimental
     */
    static set(type: string): string;
    /**
     * @experimental
     */
    static tuple(...elements: string[]): string;
    /**
     * @experimental
     */
    static object(attributes: {
        [key: string]: string;
    }): string;
}
/**
 * @experimental
 */
export interface TerraformVariableConfig {
    /**
     * @experimental
     */
    readonly default?: any;
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The type argument in a variable block allows you to restrict the type of value that will be accepted as the value for a variable.
     *
     * If no type constraint is set then a value of any type is accepted.
     *
     * While type constraints are optional, we recommend specifying them; they serve as easy reminders for users of the module, and allow Terraform to return a helpful error message if the wrong type is used.
     *
     * Type constraints are created from a mixture of type keywords and type constructors. The supported type keywords are:
     *
     * - string
     * - number
     * - bool
     *
     * The type constructors allow you to specify complex types such as collections:
     *
     * - list(\<TYPE\>)
     * - set(\<TYPE\>)
     * - map(\<TYPE\>)
     * - object({\<ATTR NAME\> = \<TYPE\>, ... })
     * - tuple([\<TYPE\>, ...])
     *
     * The keyword any may be used to indicate that any type is acceptable. For more information on the meaning and behavior of these different types, as well as detailed information about automatic conversion of complex types, see {@link https://www.terraform.io/docs/configuration/types.html|Type Constraints}.
     *
     * If both the type and default arguments are specified, the given default value must be convertible to the specified type.
     *
     * @experimental
     */
    readonly type?: string;
    /**
     * @experimental
     */
    readonly sensitive?: boolean;
}
/**
 * @experimental
 */
export declare class TerraformVariable extends TerraformElement implements ITerraformAddressable {
    /**
     * @experimental
     */
    readonly default?: any;
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * @experimental
     */
    readonly type?: string;
    /**
     * @experimental
     */
    readonly sensitive?: boolean;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, config: TerraformVariableConfig);
    /**
     * @experimental
     */
    get stringValue(): string;
    /**
     * @experimental
     */
    get numberValue(): number;
    /**
     * @experimental
     */
    get listValue(): string[];
    /**
     * @experimental
     */
    get booleanValue(): boolean;
    /**
     * @experimental
     */
    get value(): any;
    private interpolation;
    /**
     * @experimental
     */
    get fqn(): string;
    /**
     * @experimental
     */
    synthesizeAttributes(): {
        [key: string]: any;
    };
    /**
     * @experimental
     */
    toTerraform(): any;
}
