"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformVariable = exports.VariableType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const terraform_element_1 = require("./terraform-element");
const util_1 = require("./util");
const tokens_1 = require("./tokens");
const tfExpression_1 = require("./tfExpression");
/**
 * @experimental
 */
class VariableType {
    /**
     * @experimental
     */
    static list(type) {
        return `list(${type})`;
    }
    /**
     * @experimental
     */
    static map(type) {
        return `map(${type})`;
    }
    /**
     * @experimental
     */
    static set(type) {
        return `set(${type})`;
    }
    /**
     * @experimental
     */
    static tuple(...elements) {
        return `tuple(${elements.join(", ")})`;
    }
    /**
     * @experimental
     */
    static object(attributes) {
        return `object({${Object.keys(attributes)
            .map((k) => k + "=" + attributes[k])
            .join(", ")}})`;
    }
}
exports.VariableType = VariableType;
_a = JSII_RTTI_SYMBOL_1;
VariableType[_a] = { fqn: "cdktf.VariableType", version: "0.9.0-pre.6" };
/**
 * @experimental
 */
VariableType.STRING = "string";
/**
 * @experimental
 */
VariableType.NUMBER = "number";
/**
 * @experimental
 */
VariableType.BOOL = "bool";
/**
 * @experimental
 */
VariableType.ANY = "any";
/**
 * @experimental
 */
VariableType.LIST = "list";
/**
 * @experimental
 */
VariableType.MAP = "map";
/**
 * @experimental
 */
VariableType.SET = "set";
/**
 * @experimental
 */
VariableType.LIST_STRING = "list(string)";
/**
 * @experimental
 */
VariableType.LIST_NUMBER = "list(number)";
/**
 * @experimental
 */
VariableType.LIST_BOOL = "list(bool)";
/**
 * @experimental
 */
VariableType.MAP_STRING = "map(string)";
/**
 * @experimental
 */
VariableType.MAP_NUMBER = "map(number)";
/**
 * @experimental
 */
VariableType.MAP_BOOL = "map(bool)";
/**
 * @experimental
 */
VariableType.SET_STRING = "set(string)";
/**
 * @experimental
 */
VariableType.SET_NUMBER = "set(number)";
/**
 * @experimental
 */
VariableType.SET_BOOL = "set(bool)";
/**
 * @experimental
 */
class TerraformVariable extends terraform_element_1.TerraformElement {
    /**
     * @experimental
     */
    constructor(scope, id, config) {
        super(scope, id);
        this.default = config.default;
        this.description = config.description;
        this.type = config.type;
        this.sensitive = config.sensitive;
    }
    /**
     * @experimental
     */
    get stringValue() {
        return tokens_1.Token.asString(this.interpolation());
    }
    /**
     * @experimental
     */
    get numberValue() {
        return tokens_1.Token.asNumber(this.interpolation());
    }
    /**
     * @experimental
     */
    get listValue() {
        return tokens_1.Token.asList(this.interpolation());
    }
    /**
     * @experimental
     */
    get booleanValue() {
        return tokens_1.Token.asString(this.interpolation());
    }
    /**
     * @experimental
     */
    get value() {
        return tokens_1.Token.asAny(this.interpolation());
    }
    interpolation() {
        return tfExpression_1.ref(`var.${this.friendlyUniqueId}`);
    }
    /**
     * @experimental
     */
    get fqn() {
        return `var.${this.friendlyUniqueId}`;
    }
    /**
     * @experimental
     */
    synthesizeAttributes() {
        return {
            default: this.default,
            description: this.description,
            type: this.type,
            sensitive: this.sensitive,
        };
    }
    /**
     * @experimental
     */
    toTerraform() {
        return {
            variable: {
                [this.friendlyUniqueId]: util_1.deepMerge(util_1.keysToSnakeCase(this.synthesizeAttributes()), this.rawOverrides),
            },
        };
    }
}
exports.TerraformVariable = TerraformVariable;
_b = JSII_RTTI_SYMBOL_1;
TerraformVariable[_b] = { fqn: "cdktf.TerraformVariable", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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