"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const __1 = require("../../..");
const helper_1 = require("../../../../test/helper");
const data_source_1 = require("../../../../test/helper/data-source");
const resource_1 = require("../../../resource");
describe("#synthScope", () => {
    test("basic example", () => {
        expect(__1.Testing.synthScope((stack) => {
            new data_source_1.TestDataSource(stack, "test-data-source", {
                name: "foo",
            });
            new helper_1.TestResource(stack, "test-resource", {
                name: "bar",
            });
        })).toMatchInlineSnapshot(`
      "{
        \\"data\\": {
          \\"test_data_source\\": {
            \\"test-data-source\\": {
              \\"name\\": \\"foo\\"
            }
          }
        },
        \\"resource\\": {
          \\"test_resource\\": {
            \\"test-resource\\": {
              \\"name\\": \\"bar\\"
            }
          }
        }
      }"
    `);
    });
    test("using resource", () => {
        class MyResource extends resource_1.Resource {
            constructor(scope, id) {
                super(scope, id);
                this.resource = new helper_1.TestResource(this, "test-resource", {
                    name: "bar",
                });
            }
        }
        expect(__1.Testing.synthScope((stack) => {
            const res = new MyResource(stack, "my-resource");
            new helper_1.TestResource(stack, "resource", {
                name: res.resource.stringValue,
            });
        })).toMatchInlineSnapshot(`
      "{
        \\"resource\\": {
          \\"test_resource\\": {
            \\"my-resource_test-resource_4F34504B\\": {
              \\"name\\": \\"bar\\"
            },
            \\"resource\\": {
              \\"name\\": \\"\${test_resource.my-resource_test-resource_4F34504B.string_value}\\"
            }
          }
        }
      }"
    `);
    });
});
//# sourceMappingURL=data:application/json;base64,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