"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const jest_1 = require("../jest");
const index_1 = require("../../index");
const data_source_1 = require("../../../../test/helper/data-source");
const resource_1 = require("../../../../test/helper/resource");
describe("jest-adapter", () => {
    beforeAll(() => {
        jest_1.setupJest();
    });
    it("should add extra matchers", () => {
        expect(expect(true).toHaveResource).toBeDefined();
        expect(expect(true).toHaveResourceWithProperties).toBeDefined();
    });
    describe("jestPassEvaluation", () => {
        it("fails with jest error message", () => {
            expect(() => expect(index_1.Testing.synthScope((stack) => {
                new data_source_1.TestDataSource(stack, "test-data-source", {
                    name: "foo",
                });
                new resource_1.TestResource(stack, "test-resource", {
                    name: "bar",
                });
            })).toHaveResourceWithProperties(resource_1.TestResource, {
                name: "bazs",
                foo: expect.arrayContaining([expect.anything()]),
            })).toThrowErrorMatchingInlineSnapshot(`
        "Expected test_resource with properties {\\"name\\":\\"bazs\\",\\"foo\\":\\"expect.ArrayContaining\\"} to be present in synthesised stack.
        Found 1 test_resource resources instead:
        [
          {
            \\"name\\": \\"bar\\"
          }
        ]"
      `);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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