"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Testing = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const os = require("os");
const lib_1 = require("../../lib");
const terraform_stack_1 = require("../terraform-stack");
const manifest_1 = require("../manifest");
const features_1 = require("../features");
const jest_1 = require("./adapters/jest");
const synthesizer_1 = require("../synthesize/synthesizer");
/**
 * (experimental) Testing utilities for cdktf applications.
 *
 * @experimental
 */
class Testing {
    /* istanbul ignore next */
    constructor() {
        return;
    }
    /**
     * (experimental) Returns an app for testing with the following properties: - Output directory is a temp dir.
     *
     * @experimental
     */
    static app() {
        const outdir = fs.mkdtempSync(path.join(os.tmpdir(), "cdktf.outdir."));
        const app = new lib_1.App({ outdir, stackTraces: false });
        return this.stubVersion(this.enableFutureFlags(app));
    }
    /**
     * @experimental
     */
    static stubVersion(app) {
        app.node.setContext("cdktfVersion", "stubbed");
        app.manifest.version = "stubbed";
        return app;
    }
    /**
     * @experimental
     */
    static enableFutureFlags(app) {
        const node = app.node;
        Object.entries(features_1.FUTURE_FLAGS).forEach(([key, value]) => node.setContext(key, value));
        return app;
    }
    /**
     * @experimental
     */
    static synthScope(fn) {
        const stack = new terraform_stack_1.TerraformStack(Testing.app(), "stack");
        fn(stack);
        return Testing.synth(stack);
    }
    /**
     * (experimental) Returns the Terraform synthesized JSON.
     *
     * @experimental
     */
    static synth(stack) {
        synthesizer_1.invokeAspects(stack);
        const tfConfig = stack.toTerraform();
        function removeMetadata(item) {
            if (item !== null && typeof item === "object") {
                if (Array.isArray(item)) {
                    return item.map(removeMetadata);
                }
                const cleanedItem = Object.entries(item)
                    // order alphabetically
                    .sort(([a], [b]) => a.localeCompare(b))
                    .reduce((acc, [key, value]) => ({ ...acc, [key]: removeMetadata(value) }), {});
                // Remove metadata
                delete cleanedItem["//"];
                return cleanedItem;
            }
            return item;
        }
        const cleaned = removeMetadata(tfConfig);
        return JSON.stringify(cleaned, null, 2);
    }
    /**
     * @experimental
     */
    static fullSynth(stack) {
        const outdir = fs.mkdtempSync(path.join(os.tmpdir(), "cdktf.outdir."));
        const manifest = new manifest_1.Manifest("stubbed", outdir);
        stack.synthesizer.synthesize({
            outdir,
            manifest,
        });
        manifest.writeToFile();
        return outdir;
    }
    /**
     * @experimental
     */
    static renderConstructTree(construct) {
        return render(construct, 0, false);
        function render(construct, level, isLast) {
            let prefix = "";
            if (level > 0) {
                const spaces = " ".repeat((level - 1) * 4);
                const symbol = isLast ? "└" : "├";
                prefix = `${spaces}${symbol}── `;
            }
            const name = construct instanceof lib_1.App
                ? "App"
                : `${construct.node.id} (${construct.constructor.name})`;
            return `${prefix}${name}\n${construct.node.children
                .map((child, idx, arr) => {
                const isLast = idx === arr.length - 1;
                return render(child, level + 1, isLast);
            })
                .join("")}`;
        }
    }
    /**
     * @experimental
     */
    static setupJest() {
        jest_1.setupJest();
    }
}
exports.Testing = Testing;
_a = JSII_RTTI_SYMBOL_1;
Testing[_a] = { fqn: "cdktf.Testing", version: "0.9.0-pre.6" };
//# sourceMappingURL=data:application/json;base64,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