import { IResolvable, IResolveContext } from "./tokens/resolvable";
import { Intrinsic } from "./tokens/private/intrinsic";
declare class TFExpression extends Intrinsic implements IResolvable {
    isInnerTerraformExpression: boolean;
    protected resolveArg(context: IResolveContext, arg: any): string;
    /**
     * Escape string removes characters from the string that are not allowed in Terraform or JSON
     * It must only be used on non-token values
     */
    protected escapeString(str: string): string;
    private resolveString;
}
export declare function rawString(str: string): IResolvable;
declare class Reference extends TFExpression {
    private identifier;
    constructor(identifier: string);
    resolve(): string;
}
export declare function ref(identifier: string): IResolvable;
declare class PropertyAccess extends TFExpression {
    private target;
    private args;
    constructor(target: Expression, args: Expression[]);
    resolve(context: IResolveContext): string;
}
export declare function propertyAccess(target: Expression, args: Expression[]): IResolvable;
declare class ConditionalExpression extends TFExpression {
    private condition;
    private trueValue;
    private falseValue;
    constructor(condition: Expression, trueValue: Expression, falseValue: Expression);
    resolve(context: IResolveContext): string;
}
/**
 * creates an expression like `true ? 1 : 0`
 */
export declare function conditional(condition: Expression, trueValue: Expression, falseValue: Expression): ConditionalExpression;
export declare type Operator = "!" | "-" | "*" | "/" | "%" | "+" | ">" | ">=" | "<" | "<=" | "==" | "!=" | "&&" | "||";
declare class OperatorExpression extends TFExpression {
    private operator;
    private left;
    private right?;
    constructor(operator: Operator, left: Expression, right?: any);
    resolve(context: IResolveContext): string;
}
export declare function notOperation(expression: Expression): IResolvable;
export declare function negateOperation(expression: Expression): IResolvable;
export declare function mulOperation(left: Expression, right: Expression): IResolvable;
export declare function divOperation(left: Expression, right: Expression): IResolvable;
export declare function modOperation(left: Expression, right: Expression): IResolvable;
export declare function addOperation(left: Expression, right: Expression): IResolvable;
export declare function subOperation(left: Expression, right: Expression): IResolvable;
export declare function gtOperation(left: Expression, right: Expression): IResolvable;
export declare function gteOperation(left: Expression, right: Expression): IResolvable;
export declare function ltOperation(left: Expression, right: Expression): IResolvable;
export declare function lteOperation(left: Expression, right: Expression): IResolvable;
export declare function eqOperation(left: Expression, right: Expression): IResolvable;
export declare function neqOperation(left: Expression, right: Expression): IResolvable;
export declare function andOperation(left: Expression, right: Expression): IResolvable;
export declare function orOperation(left: Expression, right: Expression): IResolvable;
declare class FunctionCall extends TFExpression {
    private name;
    private args;
    constructor(name: string, args: Expression[]);
    resolve(context: IResolveContext): string;
}
export declare function call(name: string, args: Expression[]): IResolvable;
export declare type Expression = Reference | FunctionCall | PropertyAccess | ConditionalExpression | OperatorExpression | string | string[] | number | boolean | IResolvable | {
    [key: string]: any;
} | null | any | any[];
export {};
