import { IPostProcessor, IResolvable, IResolveContext } from "./resolvable";
/**
 * (experimental) Interface for lazy string producers.
 *
 * @experimental
 */
export interface IStringProducer {
    /**
     * (experimental) Produce the string value.
     *
     * @experimental
     */
    produce(context: IResolveContext): string | undefined;
}
/**
 * (experimental) Interface for lazy list producers.
 *
 * @experimental
 */
export interface IListProducer {
    /**
     * (experimental) Produce the list value.
     *
     * @experimental
     */
    produce(context: IResolveContext): string[] | undefined;
}
/**
 * (experimental) Interface for lazy number producers.
 *
 * @experimental
 */
export interface INumberProducer {
    /**
     * (experimental) Produce the number value.
     *
     * @experimental
     */
    produce(context: IResolveContext): number | undefined;
}
/**
 * (experimental) Interface for lazy untyped value producers.
 *
 * @experimental
 */
export interface IAnyProducer {
    /**
     * (experimental) Produce the value.
     *
     * @experimental
     */
    produce(context: IResolveContext): any;
}
/**
 * (experimental) Options for creating a lazy string token.
 *
 * @experimental
 */
export interface LazyStringValueOptions {
    /**
     * (experimental) Use the given name as a display hint.
     *
     * @default - No hint
     * @experimental
     */
    readonly displayHint?: string;
}
/**
 * (experimental) Options for creating a lazy list token.
 *
 * @experimental
 */
export interface LazyListValueOptions {
    /**
     * (experimental) Use the given name as a display hint.
     *
     * @default - No hint
     * @experimental
     */
    readonly displayHint?: string;
    /**
     * (experimental) If the produced list is empty, return 'undefined' instead.
     *
     * @default false
     * @experimental
     */
    readonly omitEmpty?: boolean;
}
/**
 * (experimental) Options for creating lazy untyped tokens.
 *
 * @experimental
 */
export interface LazyAnyValueOptions {
    /**
     * (experimental) Use the given name as a display hint.
     *
     * @default - No hint
     * @experimental
     */
    readonly displayHint?: string;
    /**
     * (experimental) If the produced value is an array and it is empty, return 'undefined' instead.
     *
     * @default false
     * @experimental
     */
    readonly omitEmptyArray?: boolean;
}
/**
 * (experimental) Lazily produce a value.
 *
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 *
 * @experimental
 */
export declare class Lazy {
    /**
     * (experimental) Returns a stringified token for a lazy value.
     *
     * @param producer The producer.
     * @param options Options.
     * @experimental
     */
    static stringValue(producer: IStringProducer, options?: LazyStringValueOptions): string;
    /**
     * (experimental) Returns a numberified token for a lazy value.
     *
     * @param producer The producer.
     * @experimental
     */
    static numberValue(producer: INumberProducer): number;
    /**
     * (experimental) Returns a list-ified token for a lazy value.
     *
     * @param producer The producer.
     * @param options Options.
     * @experimental
     */
    static listValue(producer: IListProducer, options?: LazyListValueOptions): string[];
    /**
     * (experimental) Produces a lazy token from an untyped value.
     *
     * @param producer The lazy producer.
     * @param options Options.
     * @experimental
     */
    static anyValue(producer: IAnyProducer, options?: LazyAnyValueOptions): IResolvable;
}
/**
 * @experimental
 */
export declare abstract class LazyBase implements IResolvable {
    /**
     * (experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.
     *
     * If this returns an empty array the stack will not be attached.
     *
     * @experimental
     */
    readonly creationStack: string[];
    private postProcessors;
    /**
     * @experimental
     */
    constructor();
    /**
     * (experimental) Produce the Token's value at resolution time.
     *
     * @experimental
     */
    resolve(context: IResolveContext): any;
    /**
     * @experimental
     */
    protected abstract resolveLazy(context: IResolveContext): any;
    /**
     * (experimental) Return a string representation of this resolvable object.
     *
     * Returns a reversible string representation.
     *
     * @experimental
     */
    toString(): string;
    /**
     * @experimental
     */
    addPostProcessor(postProcessor: IPostProcessor): void;
    /**
     * (experimental) Turn this Token into JSON.
     *
     * Called automatically when JSON.stringify() is called on a Token.
     *
     * @experimental
     */
    toJSON(): any;
}
