"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.captureStackTrace = void 0;
// copied from https://github.com/aws/constructs/blob/e01e47f78ef1e9b600efcd23ff7705aa8d384017/lib/private/stack-trace.ts
// eslint-disable-next-line @typescript-eslint/ban-types
function captureStackTrace(below) {
    below = below || captureStackTrace; // hide myself if nothing else
    const object = { stack: "" };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack
        .split("\n")
        .slice(1)
        .map((s) => s.replace(/^\s*at\s+/, ""));
}
exports.captureStackTrace = captureStackTrace;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2stdHJhY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay10cmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx5SEFBeUg7QUFDekgsd0RBQXdEO0FBQ3hELFNBQWdCLGlCQUFpQixDQUFDLEtBQWdCO0lBQ2hELEtBQUssR0FBRyxLQUFLLElBQUksaUJBQWlCLENBQUMsQ0FBQyw4QkFBOEI7SUFDbEUsTUFBTSxNQUFNLEdBQUcsRUFBRSxLQUFLLEVBQUUsRUFBRSxFQUFFLENBQUM7SUFDN0IsTUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLGVBQWUsQ0FBQztJQUM1QyxJQUFJO1FBQ0YsS0FBSyxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDaEQsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsQ0FBQztLQUN4QztZQUFTO1FBQ1IsS0FBSyxDQUFDLGVBQWUsR0FBRyxhQUFhLENBQUM7S0FDdkM7SUFDRCxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRTtRQUNqQixPQUFPLEVBQUUsQ0FBQztLQUNYO0lBQ0QsT0FBTyxNQUFNLENBQUMsS0FBSztTQUNoQixLQUFLLENBQUMsSUFBSSxDQUFDO1NBQ1gsS0FBSyxDQUFDLENBQUMsQ0FBQztTQUNSLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQztBQUM1QyxDQUFDO0FBakJELDhDQWlCQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGNvcGllZCBmcm9tIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MvY29uc3RydWN0cy9ibG9iL2UwMWU0N2Y3OGVmMWU5YjYwMGVmY2QyM2ZmNzcwNWFhOGQzODQwMTcvbGliL3ByaXZhdGUvc3RhY2stdHJhY2UudHNcbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBAdHlwZXNjcmlwdC1lc2xpbnQvYmFuLXR5cGVzXG5leHBvcnQgZnVuY3Rpb24gY2FwdHVyZVN0YWNrVHJhY2UoYmVsb3c/OiBGdW5jdGlvbik6IHN0cmluZ1tdIHtcbiAgYmVsb3cgPSBiZWxvdyB8fCBjYXB0dXJlU3RhY2tUcmFjZTsgLy8gaGlkZSBteXNlbGYgaWYgbm90aGluZyBlbHNlXG4gIGNvbnN0IG9iamVjdCA9IHsgc3RhY2s6IFwiXCIgfTtcbiAgY29uc3QgcHJldmlvdXNMaW1pdCA9IEVycm9yLnN0YWNrVHJhY2VMaW1pdDtcbiAgdHJ5IHtcbiAgICBFcnJvci5zdGFja1RyYWNlTGltaXQgPSBOdW1iZXIuTUFYX1NBRkVfSU5URUdFUjtcbiAgICBFcnJvci5jYXB0dXJlU3RhY2tUcmFjZShvYmplY3QsIGJlbG93KTtcbiAgfSBmaW5hbGx5IHtcbiAgICBFcnJvci5zdGFja1RyYWNlTGltaXQgPSBwcmV2aW91c0xpbWl0O1xuICB9XG4gIGlmICghb2JqZWN0LnN0YWNrKSB7XG4gICAgcmV0dXJuIFtdO1xuICB9XG4gIHJldHVybiBvYmplY3Quc3RhY2tcbiAgICAuc3BsaXQoXCJcXG5cIilcbiAgICAuc2xpY2UoMSlcbiAgICAubWFwKChzKSA9PiBzLnJlcGxhY2UoL15cXHMqYXRcXHMrLywgXCJcIikpO1xufVxuIl19