import { IConstruct } from "constructs";
import { TokenizedStringFragments } from "./string-fragments";
/**
 * (experimental) Current resolution context for tokens.
 *
 * @experimental
 */
export interface IResolveContext {
    /**
     * (experimental) The scope from which resolution has been initiated.
     *
     * @experimental
     */
    readonly scope: IConstruct;
    /**
     * (experimental) True when we are still preparing, false if we're rendering the final output.
     *
     * @experimental
     */
    readonly preparing: boolean;
    /**
     * (experimental) Resolve an inner object.
     *
     * @experimental
     */
    resolve(x: any): any;
    /**
     * (experimental) Use this postprocessor after the entire token structure has been resolved.
     *
     * @experimental
     */
    registerPostProcessor(postProcessor: IPostProcessor): void;
}
/**
 * (experimental) Interface for values that can be resolvable later.
 *
 * Tokens are special objects that participate in synthesis.
 *
 * @experimental
 */
export interface IResolvable {
    /**
     * (experimental) The creation stack of this resolvable which will be appended to errors thrown during resolution.
     *
     * If this returns an empty array the stack will not be attached.
     *
     * @experimental
     */
    readonly creationStack: string[];
    /**
     * (experimental) Produce the Token's value at resolution time.
     *
     * @experimental
     */
    resolve(context: IResolveContext): any;
    /**
     * (experimental) Return a string representation of this resolvable object.
     *
     * Returns a reversible string representation.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) A Token that can post-process the complete resolved value, after resolve() has recursed over it.
 *
 * @experimental
 */
export interface IPostProcessor {
    /**
     * (experimental) Process the completely resolved value, after full recursion/resolution has happened.
     *
     * @experimental
     */
    postProcess(input: any, context: IResolveContext): any;
}
/**
 * (experimental) How to resolve tokens.
 *
 * @experimental
 */
export interface ITokenResolver {
    /**
     * (experimental) Resolve a single token.
     *
     * @experimental
     */
    resolveToken(t: IResolvable, context: IResolveContext, postProcessor: IPostProcessor): any;
    /**
     * (experimental) Resolve a string with at least one stringified token in it.
     *
     * (May use concatenation)
     *
     * @experimental
     */
    resolveString(s: TokenizedStringFragments, context: IResolveContext): any;
    /**
     * (experimental) Resolve a tokenized list.
     *
     * @experimental
     */
    resolveList(l: string[], context: IResolveContext): any;
}
/**
 * (experimental) Function used to concatenate symbols in the target document language.
 *
 * Interface so it could potentially be exposed over jsii.
 *
 * @experimental
 */
export interface IFragmentConcatenator {
    /**
     * (experimental) Join the fragment on the left and on the right.
     *
     * @experimental
     */
    join(left: any | undefined, right: any | undefined): any;
}
/**
 * (experimental) Converts all fragments to strings and concats those.
 *
 * Drops 'undefined's.
 *
 * @experimental
 */
export declare class StringConcat implements IFragmentConcatenator {
    /**
     * (experimental) Join the fragment on the left and on the right.
     *
     * @experimental
     */
    join(left: any | undefined, right: any | undefined): any;
}
/**
 * (experimental) Default resolver implementation.
 *
 * @experimental
 */
export declare class DefaultTokenResolver implements ITokenResolver {
    private readonly concat;
    /**
     * @experimental
     */
    constructor(concat: IFragmentConcatenator);
    /**
     * (experimental) Default Token resolution.
     *
     * Resolve the Token, recurse into whatever it returns,
     * then finally post-process it.
     *
     * @experimental
     */
    resolveToken(t: IResolvable, context: IResolveContext, postProcessor: IPostProcessor): any;
    /**
     * (experimental) Resolve string fragments to Tokens.
     *
     * @experimental
     */
    resolveString(fragments: TokenizedStringFragments, context: IResolveContext): any;
    /**
     * (experimental) Resolve a tokenized list.
     *
     * @experimental
     */
    resolveList(xs: string[], context: IResolveContext): any;
}
