import { IFragmentConcatenator, IResolvable } from "./resolvable";
/**
 * (experimental) Fragments of a concatenated string containing stringified Tokens.
 *
 * @experimental
 */
export declare class TokenizedStringFragments {
    private readonly fragments;
    /**
     * (experimental) Returns the first token.
     *
     * @experimental
     */
    get firstToken(): IResolvable | undefined;
    /**
     * (experimental) Returns the first value.
     *
     * @experimental
     */
    get firstValue(): any;
    /**
     * (experimental) Returns the number of fragments.
     *
     * @experimental
     */
    get length(): number;
    /**
     * (experimental) Adds a literal fragment.
     *
     * @param lit the literal to add.
     * @experimental
     */
    addLiteral(lit: any): void;
    /**
     * (experimental) Adds a token fragment.
     *
     * @param token the token to add.
     * @experimental
     */
    addToken(token: IResolvable): void;
    /**
     * (experimental) Adds an intrinsic fragment.
     *
     * @param value the intrinsic value to add.
     * @experimental
     */
    addIntrinsic(value: any): void;
    /**
     * (experimental) Return all Tokens from this string.
     *
     * @experimental
     */
    get tokens(): IResolvable[];
    /**
     * (experimental) Return all literals from this string.
     *
     * @experimental
     */
    get literals(): IResolvable[];
    /**
     * (experimental) Return all intrinsic fragments from this string.
     *
     * @experimental
     */
    get intrinsic(): IResolvable[];
    /**
     * (experimental) Apply a transformation function to all tokens in the string.
     *
     * @experimental
     */
    mapTokens(mapper: ITokenMapper): TokenizedStringFragments;
    /**
     * (experimental) Combine the string fragments using the given joiner.
     *
     * If there are any
     *
     * @experimental
     */
    join(concat: IFragmentConcatenator): any;
}
/**
 * (experimental) Interface to apply operation to tokens in a string.
 *
 * Interface so it can be exported via jsii.
 *
 * @experimental
 */
export interface ITokenMapper {
    /**
     * (experimental) Replace a single token.
     *
     * @experimental
     */
    mapToken(t: IResolvable): any;
}
