# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/03-texts.ipynb (unless otherwise specified).

__all__ = ['welcome_text', 'settings_text', 'after_rocket_text', 'start_search_text', 'stop_search_text',
           'see_search_setting_text', 'no_recommended_vacancies_text', 'proforientation', 'payment_text']

# Cell
import pandas as pd

# Cell

# сообщение после нажатия /start:

def welcome_text():
    return """
           Привет! Я бот ... Я помогу ... . Я буду ...... каждый день. Начнем?
           """

# Cell

# сообщение внутри меню настроек:

def settings_text(status, search_settings, expiration_date):
    return  f"""
Нажми <b>"Настроить поиск"</b>, чтобы заполнить критерии поиска и добавить свое резюме.

После заполнения поиск подходящих вакансий начнется автоматически.

<b>Статус:</b> <i>{status}</i>
<b>Критерии поиска:</b> <i>{search_settings}</i>
<b>До конца подписки:</b> <i>{(expiration_date - pd.Timestamp.now()).days} д. {(expiration_date - pd.Timestamp.now()).seconds//3600} ч.</i>

"""

# Cell

# сообщение после нажатия 'Вперед! 🚀':

def after_rocket_text():
    return  f"""
В нижнем левом углу экрана будет доступна кнопка <b>«Menu»</b>.

Нажми ее и выбери команду\n<b>«⚙️ Настроить поиск»</b> для загрузки резюме и выбора фильтров вакансий.
"""

# Cell

# сообщение после нажатия '▶️ Запустить поиск':

def start_search_text():
       return """
🚀 Поиск запущен. Ежедневно я буду присылать новые вакансии, если найду что-нибудь подходящее.
А пока покажу недавние вакансии по твоему запросу. <i>Секундочку...</i>
"""

# Cell

# сообщение после нажатия '⏸️ Остановить поиск':

def stop_search_text():
       return """
😴 Поиск остановлен. Возобновить его ты всегда можешь в настройках поиска.
"""

# Cell

# cообщение после нажатия '👀 Посмотреть мои критерии поиска':

def see_search_setting_text(cv, max_responses, min_salary, experience, remote, inserted_into_db_msk):
    if cv == None: cv = 'не загружено'
    else: cv = 'загружено'

    if min_salary != 'не задано': min_salary = f'{min_salary} руб.'

    if remote==1: remote = 'только удалëнный'
    else: remote = 'любой'

    return f"""
🧐 <i><b>ТЕКУЩИЕ КРИТЕРИИ ПОИСКА:</b></i>

<b>Резюме:</b> <i>{cv}</i>

<b>Макс. количество откликов:</b> <i>{max_responses}</i>

<b>Мин. уровень дохода:</b> <i>{min_salary}</i>

<b>Опыт:</b> <i>{experience}</i>

<b>Формат:</b> <i>{remote}</i>

<b>Дата последней настройки поиска:</b> <i>{inserted_into_db_msk}</i>
"""

# Cell

# сообщение если не нашлось рекомендуемых вакансий для chat_id сегодня:

def no_recommended_vacancies_text():
    return """
😔 Сегодня для тебя не нашлось новых вакансий!

Попробуй расширить критерии поиска или подожди пока я смогу найти что-то подходящее завтра!
"""

# Cell

# cообщение после нажатия '👨‍💻 Профориентация':

def proforientation(professionalrole_vs_avg_similarity):
    best_5_professionalroles = professionalrole_vs_avg_similarity.head(5)['professional_role'].to_list()

    return f"""
🧐 <i><b>ТОП 5 СПЕЦИАЛЬНОСТЕЙ, ПОДХОДЯЩИХ ТВОЕМУ РЕЗЮМЕ:</b></i>

1️⃣ {best_5_professionalroles[0]}

2️⃣ {best_5_professionalroles[1]}

3️⃣ {best_5_professionalroles[2]}

4️⃣ {best_5_professionalroles[3]}

5️⃣ {best_5_professionalroles[4]}
"""

# Cell

# текст в сообщении после нажатия "Оплатить подписку":
def payment_text(secs):
    remaining_minutes = secs // 60
    remaining_secs = secs % 60
    return f"""
<i><b>Выберите вариант оплаты:</b></i>

Осталось: <i>{remaining_minutes} мин. {remaining_secs} сек.</i>

<b>После истечения времени оплата не сможет быть проверена автоматически!</b>
"""