from configparser import ConfigParser
from setuptools import setup, find_packages

config = ConfigParser(delimiters=['='])
config.read('settings.ini')
cfg = config['DEFAULT']

setup(
    name = cfg['lib_name'],
    version=cfg['version'],
    packages=find_packages(),
    install_requires = ['pandas', 'fastcore', 'sqlalchemy==1.4.46', 'sshtunnel==0.4.0', 'loguru', 'psycopg2-binary', 'oceano-algos', 'selenium', 'beautifulsoup4', 'numpy', 'tqdm', 'psutil', 'boltons', 'pytelegrambotapi==4.10.0', 'pymystem3==0.2.0', 'scikit-learn==1.0.2', 'cryptocode', 'yoomoney'], # <-- DO NOT EDIT, THIS LINE IS AUTOGENERATED
    long_description=cfg['long_description'],
    description=cfg['description']
)