from dataclasses import dataclass
from typing import Dict

@dataclass
class SpeakerStyle:
    """話者とその特定のスタイル情報を格納します。"""
    name: str
    speaker_uuid: str
    id: int
    style_name: str
    style_type: str
    version: str
    supported_features: Dict[str, str]

shikoku_metan_normal = SpeakerStyle(name='四国めたん', speaker_uuid='7ffcb7ce-00ec-4bdc-82cd-45a8889e43ff', id=2, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
shikoku_metan_amaama = SpeakerStyle(name='四国めたん', speaker_uuid='7ffcb7ce-00ec-4bdc-82cd-45a8889e43ff', id=0, style_name='あまあま', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
shikoku_metan_tsuntsun = SpeakerStyle(name='四国めたん', speaker_uuid='7ffcb7ce-00ec-4bdc-82cd-45a8889e43ff', id=6, style_name='ツンツン', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
shikoku_metan_sexy = SpeakerStyle(name='四国めたん', speaker_uuid='7ffcb7ce-00ec-4bdc-82cd-45a8889e43ff', id=4, style_name='セクシー', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
shikoku_metan_sasayaki = SpeakerStyle(name='四国めたん', speaker_uuid='7ffcb7ce-00ec-4bdc-82cd-45a8889e43ff', id=36, style_name='ささやき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
shikoku_metan_hisohiso = SpeakerStyle(name='四国めたん', speaker_uuid='7ffcb7ce-00ec-4bdc-82cd-45a8889e43ff', id=37, style_name='ヒソヒソ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_normal = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=3, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_amaama = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=1, style_name='あまあま', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_tsuntsun = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=7, style_name='ツンツン', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_sexy = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=5, style_name='セクシー', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_sasayaki = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=22, style_name='ささやき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_hisohiso = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=38, style_name='ヒソヒソ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_herohero = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=75, style_name='ヘロヘロ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zundamon_namidame = SpeakerStyle(name='ずんだもん', speaker_uuid='388f246b-8c41-4ac1-8e2d-5d79f3ff56d9', id=76, style_name='なみだめ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
kasukabe_tsumugi_normal = SpeakerStyle(name='春日部つむぎ', speaker_uuid='35b2c544-660e-401e-b503-0e14c635303a', id=8, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
amahare_hau_normal = SpeakerStyle(name='雨晴はう', speaker_uuid='3474ee95-c274-47f9-aa1a-8322163d96f1', id=10, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
namine_ritsu_normal = SpeakerStyle(name='波音リツ', speaker_uuid='b1a81618-b27b-40d2-b0ea-27a9ad408c4b', id=9, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
namine_ritsu_queen = SpeakerStyle(name='波音リツ', speaker_uuid='b1a81618-b27b-40d2-b0ea-27a9ad408c4b', id=65, style_name='クイーン', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kurono_takehiro_normal = SpeakerStyle(name='玄野武宏', speaker_uuid='c30dc15a-0992-4f8d-8bb8-ad3b314e6a6f', id=11, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kurono_takehiro_yorokobi = SpeakerStyle(name='玄野武宏', speaker_uuid='c30dc15a-0992-4f8d-8bb8-ad3b314e6a6f', id=39, style_name='喜び', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kurono_takehiro_tsungire = SpeakerStyle(name='玄野武宏', speaker_uuid='c30dc15a-0992-4f8d-8bb8-ad3b314e6a6f', id=40, style_name='ツンギレ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kurono_takehiro_kanashimi = SpeakerStyle(name='玄野武宏', speaker_uuid='c30dc15a-0992-4f8d-8bb8-ad3b314e6a6f', id=41, style_name='悲しみ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
shirakami_kotarou_futsuu = SpeakerStyle(name='白上虎太郎', speaker_uuid='e5020595-5c5d-4e87-b849-270a518d0dcf', id=12, style_name='ふつう', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
shirakami_kotarou_waai = SpeakerStyle(name='白上虎太郎', speaker_uuid='e5020595-5c5d-4e87-b849-270a518d0dcf', id=32, style_name='わーい', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
shirakami_kotarou_bikubiku = SpeakerStyle(name='白上虎太郎', speaker_uuid='e5020595-5c5d-4e87-b849-270a518d0dcf', id=33, style_name='びくびく', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
shirakami_kotarou_oko = SpeakerStyle(name='白上虎太郎', speaker_uuid='e5020595-5c5d-4e87-b849-270a518d0dcf', id=34, style_name='おこ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
shirakami_kotarou_bieen = SpeakerStyle(name='白上虎太郎', speaker_uuid='e5020595-5c5d-4e87-b849-270a518d0dcf', id=35, style_name='びえーん', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aoyama_ryusei_normal = SpeakerStyle(name='青山龍星', speaker_uuid='4f51116a-d9ee-4516-925d-21f183e2afad', id=13, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aoyama_ryusei_nekketsu = SpeakerStyle(name='青山龍星', speaker_uuid='4f51116a-d9ee-4516-925d-21f183e2afad', id=81, style_name='熱血', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aoyama_ryusei_fukigen = SpeakerStyle(name='青山龍星', speaker_uuid='4f51116a-d9ee-4516-925d-21f183e2afad', id=82, style_name='不機嫌', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aoyama_ryusei_yorokobi = SpeakerStyle(name='青山龍星', speaker_uuid='4f51116a-d9ee-4516-925d-21f183e2afad', id=83, style_name='喜び', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aoyama_ryusei_shittori = SpeakerStyle(name='青山龍星', speaker_uuid='4f51116a-d9ee-4516-925d-21f183e2afad', id=84, style_name='しっとり', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aoyama_ryusei_kanashimi = SpeakerStyle(name='青山龍星', speaker_uuid='4f51116a-d9ee-4516-925d-21f183e2afad', id=85, style_name='かなしみ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aoyama_ryusei_sasayaki = SpeakerStyle(name='青山龍星', speaker_uuid='4f51116a-d9ee-4516-925d-21f183e2afad', id=86, style_name='囁き', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
meinaru_himari_normal = SpeakerStyle(name='冥鳴ひまり', speaker_uuid='8eaad775-3119-417e-8cf4-2a10bfd592c8', id=14, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kyushu_sora_normal = SpeakerStyle(name='九州そら', speaker_uuid='481fb609-6446-4870-9f46-90c4dd623403', id=16, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
kyushu_sora_amaama = SpeakerStyle(name='九州そら', speaker_uuid='481fb609-6446-4870-9f46-90c4dd623403', id=15, style_name='あまあま', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
kyushu_sora_tsuntsun = SpeakerStyle(name='九州そら', speaker_uuid='481fb609-6446-4870-9f46-90c4dd623403', id=18, style_name='ツンツン', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
kyushu_sora_sexy = SpeakerStyle(name='九州そら', speaker_uuid='481fb609-6446-4870-9f46-90c4dd623403', id=17, style_name='セクシー', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
kyushu_sora_sasayaki = SpeakerStyle(name='九州そら', speaker_uuid='481fb609-6446-4870-9f46-90c4dd623403', id=19, style_name='ささやき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
mochiko_san_normal = SpeakerStyle(name='もち子さん', speaker_uuid='9f3ee141-26ad-437e-97bd-d22298d02ad2', id=20, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
mochiko_san_sexy_anko = SpeakerStyle(name='もち子さん', speaker_uuid='9f3ee141-26ad-437e-97bd-d22298d02ad2', id=66, style_name='セクシー／あん子', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
mochiko_san_naki = SpeakerStyle(name='もち子さん', speaker_uuid='9f3ee141-26ad-437e-97bd-d22298d02ad2', id=77, style_name='泣き', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
mochiko_san_ikari = SpeakerStyle(name='もち子さん', speaker_uuid='9f3ee141-26ad-437e-97bd-d22298d02ad2', id=78, style_name='怒り', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
mochiko_san_yorokobi = SpeakerStyle(name='もち子さん', speaker_uuid='9f3ee141-26ad-437e-97bd-d22298d02ad2', id=79, style_name='喜び', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
mochiko_san_nonbiri = SpeakerStyle(name='もち子さん', speaker_uuid='9f3ee141-26ad-437e-97bd-d22298d02ad2', id=80, style_name='のんびり', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
kenzaki_mesuo_normal = SpeakerStyle(name='剣崎雌雄', speaker_uuid='1a17ca16-7ee5-4ea5-b191-2f02ace24d21', id=21, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
white_cul_normal = SpeakerStyle(name='WhiteCUL', speaker_uuid='67d5d8da-acd7-4207-bb10-b5542d3a663b', id=23, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
white_cul_tanoshii = SpeakerStyle(name='WhiteCUL', speaker_uuid='67d5d8da-acd7-4207-bb10-b5542d3a663b', id=24, style_name='たのしい', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
white_cul_kanashii = SpeakerStyle(name='WhiteCUL', speaker_uuid='67d5d8da-acd7-4207-bb10-b5542d3a663b', id=25, style_name='かなしい', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
white_cul_bieen = SpeakerStyle(name='WhiteCUL', speaker_uuid='67d5d8da-acd7-4207-bb10-b5542d3a663b', id=26, style_name='びえーん', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
goki_ningen_ver = SpeakerStyle(name='後鬼', speaker_uuid='0f56c2f2-644c-49c9-8989-94e11f7129d0', id=27, style_name='人間ver.', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
goki_nuigurumi_ver = SpeakerStyle(name='後鬼', speaker_uuid='0f56c2f2-644c-49c9-8989-94e11f7129d0', id=28, style_name='ぬいぐるみver.', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
goki_ningen_ikari_ver = SpeakerStyle(name='後鬼', speaker_uuid='0f56c2f2-644c-49c9-8989-94e11f7129d0', id=87, style_name='人間（怒り）ver.', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
goki_oni_ver = SpeakerStyle(name='後鬼', speaker_uuid='0f56c2f2-644c-49c9-8989-94e11f7129d0', id=88, style_name='鬼ver.', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
no_7_normal = SpeakerStyle(name='No.7', speaker_uuid='044830d2-f23b-44d6-ac0d-b5d733caa900', id=29, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
no_7_announce = SpeakerStyle(name='No.7', speaker_uuid='044830d2-f23b-44d6-ac0d-b5d733caa900', id=30, style_name='アナウンス', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
no_7_yomikikase = SpeakerStyle(name='No.7', speaker_uuid='044830d2-f23b-44d6-ac0d-b5d733caa900', id=31, style_name='読み聞かせ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
chibishiki_ji_normal = SpeakerStyle(name='ちび式じい', speaker_uuid='468b8e94-9da4-4f7a-8715-a22a48844f9e', id=42, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
ouka_miko_normal = SpeakerStyle(name='櫻歌ミコ', speaker_uuid='0693554c-338e-4790-8982-b9c6d476dc69', id=43, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
ouka_miko_dai_ni_keitai = SpeakerStyle(name='櫻歌ミコ', speaker_uuid='0693554c-338e-4790-8982-b9c6d476dc69', id=44, style_name='第二形態', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
ouka_miko_loli = SpeakerStyle(name='櫻歌ミコ', speaker_uuid='0693554c-338e-4790-8982-b9c6d476dc69', id=45, style_name='ロリ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
sayo_normal = SpeakerStyle(name='小夜/SAYO', speaker_uuid='a8cc6d22-aad0-4ab8-bf1e-2f843924164a', id=46, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nurse_robot_type_t_normal = SpeakerStyle(name='ナースロボ＿タイプＴ', speaker_uuid='882a636f-3bac-431a-966d-c5e6bba9f949', id=47, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nurse_robot_type_t_rakuraku = SpeakerStyle(name='ナースロボ＿タイプＴ', speaker_uuid='882a636f-3bac-431a-966d-c5e6bba9f949', id=48, style_name='楽々', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nurse_robot_type_t_kyoufu = SpeakerStyle(name='ナースロボ＿タイプＴ', speaker_uuid='882a636f-3bac-431a-966d-c5e6bba9f949', id=49, style_name='恐怖', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nurse_robot_type_t_naishobanashi = SpeakerStyle(name='ナースロボ＿タイプＴ', speaker_uuid='882a636f-3bac-431a-966d-c5e6bba9f949', id=50, style_name='内緒話', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
seikishi_benizakura_normal = SpeakerStyle(name='†聖騎士 紅桜†', speaker_uuid='471e39d2-fb11-4c8c-8d89-4b322d2498e0', id=51, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
suzumatsu_shuji_normal = SpeakerStyle(name='雀松朱司', speaker_uuid='0acebdee-a4a5-4e12-a695-e19609728e30', id=52, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kigashima_sourin_normal = SpeakerStyle(name='麒ヶ島宗麟', speaker_uuid='7d1e7ba7-f957-40e5-a3fc-da49f769ab65', id=53, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
haruka_nana_normal = SpeakerStyle(name='春歌ナナ', speaker_uuid='ba5d2428-f7e0-4c20-ac41-9dd56e9178b4', id=54, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_al_normal = SpeakerStyle(name='猫使アル', speaker_uuid='00a5c10c-d3bd-459f-83fd-43180b521a44', id=55, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_al_ochitsuki = SpeakerStyle(name='猫使アル', speaker_uuid='00a5c10c-d3bd-459f-83fd-43180b521a44', id=56, style_name='おちつき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_al_ukiuki = SpeakerStyle(name='猫使アル', speaker_uuid='00a5c10c-d3bd-459f-83fd-43180b521a44', id=57, style_name='うきうき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_al_tsuyotsuyo = SpeakerStyle(name='猫使アル', speaker_uuid='00a5c10c-d3bd-459f-83fd-43180b521a44', id=110, style_name='つよつよ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_al_herohero = SpeakerStyle(name='猫使アル', speaker_uuid='00a5c10c-d3bd-459f-83fd-43180b521a44', id=111, style_name='へろへろ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_bi_normal = SpeakerStyle(name='猫使ビィ', speaker_uuid='c20a2254-0349-4470-9fc8-e5c0f8cf3404', id=58, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_bi_ochitsuki = SpeakerStyle(name='猫使ビィ', speaker_uuid='c20a2254-0349-4470-9fc8-e5c0f8cf3404', id=59, style_name='おちつき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_bi_hitomishiri = SpeakerStyle(name='猫使ビィ', speaker_uuid='c20a2254-0349-4470-9fc8-e5c0f8cf3404', id=60, style_name='人見知り', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
nekotsukai_bi_tsuyotsuyo = SpeakerStyle(name='猫使ビィ', speaker_uuid='c20a2254-0349-4470-9fc8-e5c0f8cf3404', id=112, style_name='つよつよ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
chugoku_usagi_normal = SpeakerStyle(name='中国うさぎ', speaker_uuid='1f18ffc3-47ea-4ce0-9829-0576d03a7ec8', id=61, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chugoku_usagi_odoroki = SpeakerStyle(name='中国うさぎ', speaker_uuid='1f18ffc3-47ea-4ce0-9829-0576d03a7ec8', id=62, style_name='おどろき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chugoku_usagi_kowagari = SpeakerStyle(name='中国うさぎ', speaker_uuid='1f18ffc3-47ea-4ce0-9829-0576d03a7ec8', id=63, style_name='こわがり', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chugoku_usagi_herohero = SpeakerStyle(name='中国うさぎ', speaker_uuid='1f18ffc3-47ea-4ce0-9829-0576d03a7ec8', id=64, style_name='へろへろ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
kurita_maron_normal = SpeakerStyle(name='栗田まろん', speaker_uuid='04dbd989-32d0-40b4-9e71-17c920f2a8a9', id=67, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
aierutan_normal = SpeakerStyle(name='あいえるたん', speaker_uuid='dda44ade-5f9c-4a3a-9d2c-2a976c7476d9', id=68, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
mabetsu_hanamaru_normal = SpeakerStyle(name='満別花丸', speaker_uuid='287aa49f-e56b-4530-a469-855776c84a8d', id=69, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
mabetsu_hanamaru_genki = SpeakerStyle(name='満別花丸', speaker_uuid='287aa49f-e56b-4530-a469-855776c84a8d', id=70, style_name='元気', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
mabetsu_hanamaru_sasayaki = SpeakerStyle(name='満別花丸', speaker_uuid='287aa49f-e56b-4530-a469-855776c84a8d', id=71, style_name='ささやき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
mabetsu_hanamaru_burikko = SpeakerStyle(name='満別花丸', speaker_uuid='287aa49f-e56b-4530-a469-855776c84a8d', id=72, style_name='ぶりっ子', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
mabetsu_hanamaru_boy = SpeakerStyle(name='満別花丸', speaker_uuid='287aa49f-e56b-4530-a469-855776c84a8d', id=73, style_name='ボーイ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kotoyomi_nia_normal = SpeakerStyle(name='琴詠ニア', speaker_uuid='97a4af4b-086e-4efd-b125-7ae2da85e697', id=74, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
voidoll_normal = SpeakerStyle(name='Voidoll', speaker_uuid='0ebe2c7d-96f3-4f0e-a2e3-ae13fe27c403', id=89, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'NOTHING'})
zonko_normal = SpeakerStyle(name='ぞん子', speaker_uuid='0156da66-4300-474a-a398-49eb2e8dd853', id=90, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zonko_teiketsuatsu = SpeakerStyle(name='ぞん子', speaker_uuid='0156da66-4300-474a-a398-49eb2e8dd853', id=91, style_name='低血圧', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zonko_kakusei = SpeakerStyle(name='ぞん子', speaker_uuid='0156da66-4300-474a-a398-49eb2e8dd853', id=92, style_name='覚醒', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
zonko_jikkyofu = SpeakerStyle(name='ぞん子', speaker_uuid='0156da66-4300-474a-a398-49eb2e8dd853', id=93, style_name='実況風', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chubu_tsurugi_normal = SpeakerStyle(name='中部つるぎ', speaker_uuid='4614a7de-9829-465d-9791-97eb8a5f9b86', id=94, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chubu_tsurugi_ikari = SpeakerStyle(name='中部つるぎ', speaker_uuid='4614a7de-9829-465d-9791-97eb8a5f9b86', id=95, style_name='怒り', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chubu_tsurugi_hisohiso = SpeakerStyle(name='中部つるぎ', speaker_uuid='4614a7de-9829-465d-9791-97eb8a5f9b86', id=96, style_name='ヒソヒソ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chubu_tsurugi_odoodo = SpeakerStyle(name='中部つるぎ', speaker_uuid='4614a7de-9829-465d-9791-97eb8a5f9b86', id=97, style_name='おどおど', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
chubu_tsurugi_zetsubou_to_haiboku = SpeakerStyle(name='中部つるぎ', speaker_uuid='4614a7de-9829-465d-9791-97eb8a5f9b86', id=98, style_name='絶望と敗北', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
rito_normal = SpeakerStyle(name='離途', speaker_uuid='3b91e034-e028-4acb-a08d-fbdcd207ea63', id=99, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
rito_serious = SpeakerStyle(name='離途', speaker_uuid='3b91e034-e028-4acb-a08d-fbdcd207ea63', id=101, style_name='シリアス', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
kurosawa_saeha_normal = SpeakerStyle(name='黒沢冴白', speaker_uuid='0b466290-f9b6-4718-8d37-6c0c81e824ac', id=100, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
yurei_chan_normal = SpeakerStyle(name='ユーレイちゃん', speaker_uuid='462cd6b4-c088-42b0-b357-3816e24f112e', id=102, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
yurei_chan_amaama = SpeakerStyle(name='ユーレイちゃん', speaker_uuid='462cd6b4-c088-42b0-b357-3816e24f112e', id=103, style_name='甘々', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
yurei_chan_kanashimi = SpeakerStyle(name='ユーレイちゃん', speaker_uuid='462cd6b4-c088-42b0-b357-3816e24f112e', id=104, style_name='哀しみ', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
yurei_chan_sasayaki = SpeakerStyle(name='ユーレイちゃん', speaker_uuid='462cd6b4-c088-42b0-b357-3816e24f112e', id=105, style_name='ささやき', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
yurei_chan_tsukumo_chan = SpeakerStyle(name='ユーレイちゃん', speaker_uuid='462cd6b4-c088-42b0-b357-3816e24f112e', id=106, style_name='ツクモちゃん', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'ALL'})
tohoku_zunko_normal = SpeakerStyle(name='東北ずん子', speaker_uuid='80802b2d-8c75-4429-978b-515105017010', id=107, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
tohoku_kiritan_normal = SpeakerStyle(name='東北きりたん', speaker_uuid='1bd6b32b-d650-4072-bbe5-1d0ef4aaa28b', id=108, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})
tohoku_itako_normal = SpeakerStyle(name='東北イタコ', speaker_uuid='ab4c31a3-8769-422a-b412-708f5ae637e8', id=109, style_name='ノーマル', style_type='talk', version='0.15.9', supported_features={'permitted_synthesis_morphing': 'SELF_ONLY'})

