
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/HansAschauer/schulplots/blob/main/src/notebook_example.ipynb)

# schulplots - a tool for generating 2D plots in "German school style"

`schulplots` allows you to create 2D graphs of functions that look like what students are familiar with.

The figure is described using a description file that is converted into a visual representation by `schulplots`.

## Example
<img src="images/plot_sinus.png" alt="Sine Curve" width="500"/>

This image is generated by the following description in YAML format:

```yaml
figure:
  height: 8cm
  width: 10cm
axes_descriptors:
- axes:
    height: 6cm
    width: 8cm
    x_min: -3
    y_min: -2
  bottom: 1cm
  left: 1cm
  graphs:
  - function: sin(x)
    label: $\sin(x)$
  areas:
  - function:
    - sin(x)
    - 0*x
    label: $A = \int_0^\pi \sin(x)\,dx$
    condition: y1 >= y2
    plot_args:
      alpha: 0.3
      color: red

```
The description file has main sections:
1. `figure`: This section contains information about the entire figure. In the example, it specifies the height and width of the figure.
2. `axes_descriptors`: This section contains a description of axis systems and graphs/areas to be plotted within these axis systems.

It is also possible to draw multiple axis systems with multiple graphs:

<img src="images/plot_sinus2.png" alt="Sine Curve" width="500"/>

## Installation

`schulplots` requires a recent version of Python. If you have Python installed (including pip, the python package manager), you can install it  from [PyPi](https://pypi.org/project/schulplots/) with `pip install schulplots`. 

## Run from Colab

You can use schulplots without installation directly in Google Colab. For an example, click [here](https://colab.research.google.com/github/HansAschauer/schulplots/blob/main/src/notebook_example.ipynb).
![Screenshot](images/ScreenshotColaboratory.png)

## Documentation

You can find detailed documentation [here](https://schulplots.hans-aschauer.de) (sorry, German only for now).

## Limitations

* The tool is limited to plotting function graphs in "typical" value ranges. It is intentionally not a comprehensive plotting tool for scientific purposes.
* The tool was specifically developed for the conventions commonly used in the German-speaking region for function graphs (axes at the zero line, arrows in the positive direction, squared paper with a 5mm grid, etc.).
* It is not a tool for changing graph parameters through a graphical user interface (GUI).