# flightplans

[![Python](https://img.shields.io/pypi/pyversions/flightplans)](https://img.shields.io/pypi/pyversions/flightplans)
[![Pypi](https://img.shields.io/pypi/v/flightplans)](https://pypi.org/project/flightplans/)
[![Docs](https://img.shields.io/badge/Sphinx-Docs-Green)](https://erdogant.github.io/flightplans/)
[![LOC](https://sloc.xyz/github/erdogant/flightplans/?category=code)](https://github.com/erdogant/flightplans/)
[![Downloads](https://static.pepy.tech/personalized-badge/flightplans?period=month&units=international_system&left_color=grey&right_color=brightgreen&left_text=PyPI%20downloads/month)](https://pepy.tech/project/flightplans)
[![Downloads](https://static.pepy.tech/personalized-badge/flightplans?period=total&units=international_system&left_color=grey&right_color=brightgreen&left_text=Downloads)](https://pepy.tech/project/flightplans)
[![License](https://img.shields.io/badge/license-GPL3-green.svg)](https://github.com/erdogant/flightplans/blob/master/LICENSE)
[![Forks](https://img.shields.io/github/forks/erdogant/flightplans.svg)](https://github.com/erdogant/flightplans/network)
[![Issues](https://img.shields.io/github/issues/erdogant/flightplans.svg)](https://github.com/erdogant/flightplans/issues)
[![Project Status](http://www.repostatus.org/badges/latest/active.svg)](http://www.repostatus.org/#active)
[![DOI](https://zenodo.org/badge/228166657.svg)](https://zenodo.org/badge/latestdoi/228166657)
[![Medium](https://img.shields.io/badge/Medium-Blog-green)](https://towardsdatascience.com/what-are-flightplans-loadings-and-biplots-9a7897f2e559)
[![Colab](https://colab.research.google.com/assets/colab-badge.svg?logo=github%20sponsors)](https://erdogant.github.io/flightplans/pages/html/Documentation.html#colab-notebook)
![GitHub Repo stars](https://img.shields.io/github/stars/erdogant/flightplans)
![GitHub repo size](https://img.shields.io/github/repo-size/erdogant/flightplans)
[![Donate](https://img.shields.io/badge/Support%20this%20project-grey.svg?logo=github%20sponsors)](https://erdogant.github.io/flightplans/pages/html/Documentation.html#)
<!---[![BuyMeCoffee](https://img.shields.io/badge/buymea-coffee-yellow.svg)](https://www.buymeacoffee.com/erdogant)-->
<!---[![Coffee](https://img.shields.io/badge/coffee-black-grey.svg)](https://erdogant.github.io/donate/?currency=USD&amount=5)-->





<!---[![BuyMeCoffee](https://img.shields.io/badge/buymea-coffee-yellow.svg)](https://www.buymeacoffee.com/erdogant)-->
<!---[![Coffee](https://img.shields.io/badge/coffee-black-grey.svg)](https://erdogant.github.io/donate/?currency=USD&amount=5)-->

* ``flightplans`` is Python package

# 
**Star this repo if you like it! ⭐️**
#


## Blog/Documentation

* [**flightplans documentation pages (Sphinx)**](https://erdogant.github.io/flightplans/)
* [**Notebook with examples**](https://colab.research.google.com/github/erdogant/flightplans/blob/master/notebooks/flightplans.ipynb)
* [**Read more details and usage about flightplans in this blog!**](https://towardsdatascience.com/flightplans)

* <a href="https://erdogant.github.io/flightplans/"> <img src="https://img.shields.io/badge/Sphinx-Docs-Green" alt="Open documentation pages"/> </a> flightplans documentation pages 
* <a href="https://colab.research.google.com/github/erdogant/flightplans/blob/master/notebooks/flightplans.ipynb"> <img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open example In Colab"/> </a> Notebook example 
* <a href="https://towardsdatascience.com/a-step-by-step-guide-for-clustering-images-4b45f9906128"> <img src="https://img.shields.io/badge/Medium-Blog-blue" alt="Open Blog"/> </a> Blog: A step-by-step guide for clustering images 


### Contents
- [Installation](#-installation)
- [Contribute](#-contribute)
- [Citation](#-citation)
- [Maintainers](#-maintainers)
- [License](#-copyright)

### Installation
* Install flightplans from PyPI (recommended). flightplans is compatible with Python 3.6+ and runs on Linux, MacOS X and Windows. 
* A new environment can be created as following:

```bash
conda create -n env_flightplans python=3.8
conda activate env_flightplans
```

```bash
pip install flightplans            # normal install
pip install --upgrade flightplans # or update if needed
```

* Alternatively, you can install from the GitHub source:
```bash
# Directly install from github source
pip install -e git://github.com/erdogant/flightplans.git@0.1.0#egg=master
pip install git+https://github.com/erdogant/flightplans#egg=master
pip install git+https://github.com/erdogant/flightplans

# By cloning
git clone https://github.com/erdogant/flightplans.git
cd flightplans
pip install -U .
```  

#### Import flightplans package
```python
import flightplans as flightplans
```

#### Example:
```python
df = pd.read_csv('https://github.com/erdogant/hnet/blob/master/flightplans/data/example_data.csv')
model = flightplans.fit(df)
G = flightplans.plot(model)
```
<p align="center">
  <img src="https://github.com/erdogant/flightplans/blob/master/docs/figs/fig1.png" width="600" />
  
</p>


#### References
* https://github.com/erdogant/flightplans

#### Citation
Please cite in your publications if this is useful for your research (see citation).
   
### Maintainers
* Erdogan Taskesen, github: [erdogant](https://github.com/erdogant)

### Contribute
* All kinds of contributions are welcome!
* If you wish to buy me a <a href="https://www.buymeacoffee.com/erdogant">Coffee</a> for this work, it is very appreciated :)

### Licence
See [LICENSE](LICENSE) for details.
