"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableViewer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Installs an endpoint in your stack that allows users to view the contents
 * of a DynamoDB table through their browser.
 */
class TableViewer extends constructs_1.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        const handler = new aws_cdk_lib_1.aws_lambda.Function(this, 'Rendered', {
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda')),
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            environment: {
                TABLE_NAME: props.table.tableName,
                TITLE: props.title || '',
                SORT_BY: props.sortBy || '',
            },
        });
        props.table.grantReadData(handler);
        const home = new aws_cdk_lib_1.aws_apigateway.LambdaRestApi(this, 'ViewerEndpoint', {
            handler,
            endpointConfiguration: props.endpointType
                ? { types: [props.endpointType] }
                : undefined,
        });
        this.endpoint = home.url;
    }
}
exports.TableViewer = TableViewer;
_a = JSII_RTTI_SYMBOL_1;
TableViewer[_a] = { fqn: "cdk-dynamo-table-viewer.TableViewer", version: "0.2.105" };
//# sourceMappingURL=data:application/json;base64,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