# Generated by Django 4.2.25 on 2025-10-27 18:37

# Django
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveuniverse", "0011_extend_industry_activites"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access payout system"),
                    ("create_fleet", "Can create fleets"),
                    ("manage_own_fleets", "Can manage own fleets as FC"),
                    ("manage_all_fleets", "Can manage all fleets"),
                    ("approve_payouts", "Can approve payouts"),
                    ("view_all_payouts", "Can view all payout history"),
                    ("manage_payout_rules", "Can manage payout rules"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Fleet",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(help_text="Fleet name or operation name", max_length=200),
                ),
                (
                    "doctrine",
                    models.CharField(
                        blank=True,
                        help_text="Fleet doctrine (optional)",
                        max_length=100,
                    ),
                ),
                (
                    "location",
                    models.CharField(help_text="Primary operation location", max_length=200),
                ),
                ("fleet_time", models.DateTimeField(help_text="Fleet operation time")),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("active", "Active"),
                            ("completed", "Completed"),
                            ("paid", "Paid"),
                        ],
                        default="draft",
                        help_text="Fleet status",
                        max_length=20,
                    ),
                ),
                ("notes", models.TextField(blank=True, help_text="Additional notes")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "fleet_commander",
                    models.ForeignKey(
                        help_text="Fleet commander",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="commanded_fleets",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-fleet_time"],
            },
        ),
        migrations.CreateModel(
            name="LootPool",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(default="Fleet Loot", help_text="Loot pool name", max_length=200),
                ),
                (
                    "raw_loot_text",
                    models.TextField(blank=True, help_text="Raw loot paste from EVE client"),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("draft", "Draft"),
                            ("valuing", "Valuing"),
                            ("valued", "Valued"),
                            ("approved", "Approved"),
                            ("paid", "Paid"),
                        ],
                        default="draft",
                        help_text="Loot pool status",
                        max_length=20,
                    ),
                ),
                (
                    "pricing_method",
                    models.CharField(
                        choices=[
                            ("janice_buy", "Janice - Jita Buy"),
                            ("janice_sell", "Janice - Jita Sell"),
                        ],
                        default="janice_buy",
                        help_text="Pricing method used",
                        max_length=20,
                    ),
                ),
                (
                    "total_value",
                    models.DecimalField(
                        decimal_places=2,
                        default=0,
                        help_text="Total loot value in ISK",
                        max_digits=20,
                    ),
                ),
                (
                    "corp_share_percentage",
                    models.DecimalField(
                        decimal_places=2,
                        default=10,
                        help_text="Corporation share percentage",
                        max_digits=5,
                    ),
                ),
                (
                    "corp_share_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0,
                        help_text="Corporation share amount in ISK",
                        max_digits=20,
                    ),
                ),
                (
                    "participant_share_amount",
                    models.DecimalField(
                        decimal_places=2,
                        default=0,
                        help_text="Total participant share amount in ISK",
                        max_digits=20,
                    ),
                ),
                (
                    "janice_appraisal_code",
                    models.CharField(
                        blank=True,
                        help_text="Janice appraisal code for linking",
                        max_length=50,
                    ),
                ),
                (
                    "valued_at",
                    models.DateTimeField(blank=True, help_text="Time when loot was valued", null=True),
                ),
                (
                    "approved_at",
                    models.DateTimeField(
                        blank=True,
                        help_text="Time when loot pool was approved",
                        null=True,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "approved_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="User who approved this loot pool",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="approved_loot_pools",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "fleet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="loot_pools",
                        to="aapayout.fleet",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="LootItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("type_id", models.IntegerField(help_text="EVE type ID")),
                ("name", models.CharField(help_text="Item name", max_length=200)),
                ("quantity", models.IntegerField(help_text="Item quantity")),
                (
                    "unit_price",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Price per unit in ISK",
                        max_digits=20,
                    ),
                ),
                (
                    "total_value",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Total value (quantity * unit_price)",
                        max_digits=20,
                    ),
                ),
                (
                    "price_source",
                    models.CharField(
                        choices=[
                            ("janice", "Janice API"),
                            ("manual", "Manual Override"),
                        ],
                        default="janice",
                        help_text="Source of price data",
                        max_length=20,
                    ),
                ),
                (
                    "price_fetched_at",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        help_text="Time when price was fetched",
                    ),
                ),
                (
                    "manual_override",
                    models.BooleanField(default=False, help_text="Whether price was manually overridden"),
                ),
                ("notes", models.TextField(blank=True, help_text="Additional notes")),
                (
                    "loot_pool",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="items",
                        to="aapayout.lootpool",
                    ),
                ),
            ],
            options={
                "ordering": ["-total_value"],
            },
        ),
        migrations.CreateModel(
            name="Payout",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "amount",
                    models.DecimalField(
                        decimal_places=2,
                        help_text="Payout amount in ISK",
                        max_digits=20,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("pending", "Pending"),
                            ("paid", "Paid"),
                            ("failed", "Failed"),
                        ],
                        default="pending",
                        help_text="Payment status",
                        max_length=20,
                    ),
                ),
                (
                    "payment_method",
                    models.CharField(
                        choices=[
                            ("manual", "Manual"),
                            ("contract", "Contract"),
                            ("direct_trade", "Direct Trade"),
                        ],
                        default="manual",
                        help_text="Payment method",
                        max_length=20,
                    ),
                ),
                (
                    "transaction_reference",
                    models.CharField(
                        blank=True,
                        help_text="Transaction reference or note",
                        max_length=200,
                    ),
                ),
                (
                    "paid_at",
                    models.DateTimeField(blank=True, help_text="Time when marked as paid", null=True),
                ),
                ("notes", models.TextField(blank=True, help_text="Additional notes")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "loot_pool",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payouts",
                        to="aapayout.lootpool",
                    ),
                ),
                (
                    "paid_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="User who marked this as paid",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="payouts_made",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        help_text="Payment recipient character",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.eveentity",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_at"],
                "indexes": [
                    models.Index(
                        fields=["recipient", "status"],
                        name="aapayout_pa_recipie_4dc329_idx",
                    ),
                    models.Index(
                        fields=["loot_pool", "status"],
                        name="aapayout_pa_loot_po_746301_idx",
                    ),
                ],
            },
        ),
        migrations.CreateModel(
            name="FleetParticipant",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "role",
                    models.CharField(
                        choices=[("regular", "Regular"), ("scout", "Scout")],
                        default="regular",
                        help_text="Participant role",
                        max_length=20,
                    ),
                ),
                (
                    "joined_at",
                    models.DateTimeField(default=django.utils.timezone.now, help_text="Time joined fleet"),
                ),
                (
                    "left_at",
                    models.DateTimeField(
                        blank=True,
                        help_text="Time left fleet (if applicable)",
                        null=True,
                    ),
                ),
                ("notes", models.TextField(blank=True, help_text="Additional notes")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "character",
                    models.ForeignKey(
                        help_text="EVE character (main character)",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.eveentity",
                    ),
                ),
                (
                    "fleet",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="participants",
                        to="aapayout.fleet",
                    ),
                ),
            ],
            options={
                "ordering": ["joined_at"],
                "unique_together": {("fleet", "character")},
            },
        ),
        migrations.AddIndex(
            model_name="fleet",
            index=models.Index(fields=["-fleet_time"], name="aapayout_fl_fleet_t_d9d5a4_idx"),
        ),
        migrations.AddIndex(
            model_name="fleet",
            index=models.Index(
                fields=["fleet_commander", "status"],
                name="aapayout_fl_fleet_c_34939e_idx",
            ),
        ),
    ]
