<!-- docs/_sidebar.md -->

* [Home](/)

* Getting Started
  * [Installation](/#installation)
  * [Quick Start](/#getting-started)
  * [Support Matrix](/#support-matrix)
  * [Supported Backends](/#supported-backends)

* Algorithms
  * [SFT - Supervised Fine-Tuning](/algorithms/sft)
  * [OSFT - Orthogonal Subspace Fine-Tuning](/algorithms/osft)
  * [LoRA - Low-Rank Adaptation](/algorithms/lora)

* API Reference
  * [API Overview](/api/)
  * Functions
    * [sft()](/api/functions/sft)
    * [osft()](/api/functions/osft)
    * [lora_sft()](/api/functions/lora_sft)
    * [create_algorithm()](/api/functions/create-algorithm)
  * Classes
    * [Algorithm](/api/classes/Algorithm)
    * [Backend](/api/classes/Backend)
    * [SFTAlgorithm](/api/classes/SFTAlgorithm)
    * [OSFTAlgorithm](/api/classes/OSFTAlgorithm)
    * [LoRASFTAlgorithm](/api/classes/LoRASFTAlgorithm)
    * [PEFTExtender](/api/classes/PEFTExtender)
    * [LoRAPEFTExtender](/api/classes/LoRAPEFTExtender)
    * [AlgorithmRegistry](/api/classes/AlgorithmRegistry)
  * Backends
    * [Overview](/api/backends/)
    * [InstructLab Training](/api/backends/instructlab-training)
    * [Mini-Trainer](/api/backends/mini-trainer)
    * [Unsloth](/api/backends/unsloth)
  * [Data Formats](/api/data-formats)

* Guides
  * [Distributed Training](/guides/distributed-training)
  * [Data Preparation](/guides/data-preparation)
  * [Runtime Estimates](/guides/runtime-estimates)
  * [Troubleshooting](/guides/troubleshooting)
  * [Extending the Framework](/guides/extending-framework)

* Examples
  * [Examples Overview](/examples/)

* Reference
  * [Development Guide](/DEVELOPING)
  * [GitHub Repository](https://github.com/Red-Hat-AI-Innovation-Team/training_hub)
  * [PyPI Package](https://pypi.org/project/training-hub/)
