# Data Preparation Guide

> **Note:** This guide is currently minimal and will be expanded based on user feedback and interest. If you need detailed information on any of the topics below, please let us know by [opening an issue](https://github.com/instructlab/training-hub/issues).

## Overview

This guide covers best practices for preparing training data for use with Training Hub. All training data must be in JSONL format with the messages structure. See [Data Formats](/api/data-formats) for the complete specification.

## Topics

### Data Quality

**TBD** - Guidelines for ensuring high-quality training data, including response accuracy, consistency, formatting, and length recommendations.

### Data Diversity

**TBD** - Strategies for creating diverse datasets that cover different question types, difficulty levels, edge cases, and use cases.

### Data Augmentation

**TBD** - Techniques for expanding training datasets through paraphrasing, synthetic data generation, and variation.

### Dataset Splitting

**TBD** - Best practices for splitting data into train/validation/test sets for evaluation and model selection.

### Data Validation

**TBD** - Tools and scripts for validating JSONL format, checking message structure, and identifying common issues before training.

### Dataset Size Guidelines

**TBD** - Recommendations for minimum and optimal dataset sizes for different model sizes and training objectives.

### Handling Multi-Turn Conversations

**TBD** - Guidelines for structuring multi-turn conversations with proper context flow and reference handling.

### Domain-Specific Considerations

**TBD** - Special considerations for different domains (code, medical, legal, etc.) and how to prepare domain-specific training data.

## See Also

- [**Data Formats**](/api/data-formats) - Required data format specifications
- [**SFT Algorithm**](/algorithms/sft) - Supervised fine-tuning overview
- [**OSFT Algorithm**](/algorithms/osft) - Orthogonal subspace fine-tuning overview
- [**Examples**](/examples/README) - Sample datasets and notebooks
