# 📚 Справочник Методов PyMax

## 📋 Содержание

- [Управление Чатами](#управление-чатами)
- [Управление Группами](#управление-группами)
- [Обработка Событий](#обработка-событий)
- [Управление Сообщениями](#управление-сообщениями)
- [Управление Профилем](#управление-профилем)
- [Управление Пользователями](#управление-пользователями)

## 💬 Управление чатами {#управление-чатами}

### Работа с Каналами

#### `resolve_channel_by_name(name: str) -> Channel | None`

!!! info "Описание"
    Находит и возвращает информацию о канале по его имени.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `name` | `str` | Имя канала для поиска |

**Возвращает**

`Channel | None`: Объект канала, если найден, иначе `None`

**Пример использования**

```python
channel = await client.resolve_channel_by_name("my_channel")
if channel:
    print(f"Найден канал: {channel.title}")
```

**Возвращает:**
- `Channel | None` - Объект канала или None, если канал не найден

## 👥 Управление группами {#управление-группами}

### Создание и Настройка Групп

#### `create_group(title: str, participants: list[int]) -> Chat | None`

!!! info "Описание"
    Создает новую группу с указанным названием и начальным списком участников.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `title` | `str` | Название новой группы |
| `participants` | `list[int]` | Список ID пользователей для добавления в группу |

**Пример использования**
```python
chat = await client.create_group("Моя группа", [123456, 789012])
if chat:
    print(f"Создана группа: {chat.title}")
```

### Управление Участниками

#### `invite_users_to_group(chat_id: int, user_ids: list[int]) -> bool`

!!! info "Описание"
    Приглашает новых пользователей в существующую группу.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID группы |
| `user_ids` | `list[int]` | Список ID пользователей для приглашения |

#### `remove_users_from_group(chat_id: int, user_ids: list[int]) -> bool`

!!! info "Описание"
    Удаляет пользователей из группы.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID группы |
| `user_ids` | `list[int]` | Список ID пользователей для удаления |

### Настройка Группы

#### `change_group_settings(chat_id: int, settings: dict) -> bool`

!!! info "Описание"
    Изменяет настройки группы.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID группы |
| `settings` | `dict` | Словарь с настройками группы |

#### `change_group_profile(chat_id: int, title: str | None = None, description: str | None = None) -> bool`

!!! info "Описание"
    Изменяет название и/или описание группы.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID группы |
| `title` | `str \| None` | Новое название группы (опционально) |
| `description` | `str \| None` | Новое описание группы (опционально) |

### Присоединение к Группе

#### `join_group(link: str) -> Chat | None`

!!! info "Описание"
    Присоединяется к группе по пригласительной ссылке.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `link` | `str` | Ссылка-приглашение в группу |

**Пример использования**
```python
chat = await client.join_group("https://max.ru/join/group123")
if chat:
    print(f"Присоединились к группе: {chat.title}")
```

## 🎯 Обработка событий {#обработка-событий}

### Обработчики Событий

#### `on_message(filter: Filter | None = None) -> Callable`

!!! info "Описание"
    Декоратор для обработки входящих сообщений. Позволяет установить фильтры для обработки только определенных типов сообщений.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `filter` | `Filter \| None` | Фильтр для сообщений (опционально) |

**Примеры использования**

```python
# Обработка всех сообщений
@client.on_message()
async def handle_message(message: Message):
    print(f"Получено сообщение: {message.text}")

# Обработка только текстовых сообщений
@client.on_message(Filter(chat_id=0))
async def handle_text(message: Message):
    print(f"Получено текстовое сообщение из избранного: {message.text}")
```

#### `on_start() -> Callable`

!!! info "Описание"
    Декоратор для обработки события запуска клиента. Выполняется один раз при успешном запуске и авторизации клиента.

**Пример использования**

```python
@client.on_start()
async def handle_start():
    print("Клиент успешно запущен")
    # Инициализация при запуске
    await client.send_message(
        chat_id=admin_chat,
        text="Бот запущен и готов к работе!",
        notify=True
    )
```

!!! tip "Совет"
    Вы можете использовать `on_start` для выполнения начальной настройки, загрузки данных или отправки уведомлений при запуске бота.

## 📨 Управление сообщениями {#управление-сообщениями}

### Отправка и Редактирование

#### `send_message(text: str, chat_id: int, notify: bool, photo: Photo | None = None, photos: list[Photo] | None = None, reply_to: int | None = None) -> Message | None`

!!! info "Описание"
    Отправляет сообщение в чат с возможностью прикрепления медиафайлов и ответа на другие сообщения.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `text` | `str` | Текст сообщения |
| `chat_id` | `int` | ID чата для отправки |
| `notify` | `bool` | Отправлять ли уведомление |
| `photo` | `Photo \| None` | Одно фото для прикрепления |
| `photos` | `list[Photo] \| None` | Список фото для прикрепления |
| `reply_to` | `int \| None` | ID сообщения, на которое отвечаем |

**Пример использования**
```python
# Простое сообщение
msg = await client.send_message(
    chat_id=123456,
    text="Привет!",
    notify=True
)

# Сообщение с фото
photo = Photo("/photos/photo.png")
    sg = await client.send_message(
    chat_id=123456,
    text="Смотри, какое фото!",
    photo=photo,
    notify=True
)
```

#### `edit_message(chat_id: int, message_id: int, text: str) -> Message | None`

!!! info "Описание"
    Редактирует текст существующего сообщения.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID чата |
| `message_id` | `int` | ID сообщения |
| `text` | `str` | Новый текст |

### Управление Историей

#### `fetch_history(chat_id: int, from_time: int | None = None, forward: int = 0, backward: int = 200) -> list[Message] | None`

!!! info "Описание"
    Получает историю сообщений чата.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID чата |
| `from_time` | `int \| None` | Временная метка отсчета |
| `forward` | `int` | Кол-во сообщений после from_time |
| `backward` | `int` | Кол-во сообщений до from_time |

### Работа с Медиафайлами

#### `get_video_by_id(chat_id: int, message_id: int, video_id: int) -> VideoRequest | None`

!!! info "Описание"
    Получает информацию о видео и ссылку для скачивания.

**Возвращает**
- `VideoRequest` содержит:
  - `external` - API ссылка
  - `cache` - Статус кэширования
  - `url` - Ссылка на видео

#### `get_file_by_id(chat_id: int, message_id: int, file_id: int) -> FileRequest | None`

!!! info "Описание"
    Получает информацию о файле и ссылку для скачивания.

**Возвращает**
- `FileRequest` содержит:
  - `unsafe` - Статус проверки безопасности
  - `url` - Ссылка на файл

### Модерация Сообщений

#### `delete_message(chat_id: int, message_ids: list[int], for_me: bool) -> bool`

!!! info "Описание"
    Удаляет сообщения из чата.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID чата |
| `message_ids` | `list[int]` | Список ID сообщений |
| `for_me` | `bool` | Удалить только для себя |

#### `pin_message(chat_id: int, message_id: int, notify_pin: bool) -> bool`

!!! info "Описание"
    Закрепляет сообщение в чате.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID чата |
| `message_id` | `int` | ID сообщения |
| `notify_pin` | `bool` | Уведомить о закреплении |

### Реакции на Сообщения

#### `add_reaction(chat_id: int, message_id: str, reaction: str) -> ReactionInfo | None`

!!! info "Описание"
    Добавляет эмодзи-реакцию к сообщению.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID чата |
| `message_id` | `str` | ID сообщения |
| `reaction` | `str` | Эмодзи реакции |

**Пример использования**
```python
result = await client.add_reaction(
    chat_id=123456,
    message_id="msg_123",
    reaction="👍"
)
if result:
    print(f"Всего реакций: {result.total_count}")
```

#### `get_reactions(chat_id: int, message_ids: list[str]) -> dict[str, ReactionInfo] | None`

!!! info "Описание"
    Получает информацию о реакциях на несколько сообщений.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID чата |
| `message_ids` | `list[str]` | Список ID сообщений |

#### `remove_reaction(chat_id: int, message_id: str) -> ReactionInfo | None`

!!! info "Описание"
    Удаляет реакцию текущего пользователя с сообщения.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `chat_id` | `int` | ID чата |
| `message_id` | `str` | ID сообщения |

## 👤 Управление профилем {#управление-профилем}

### Персональные Данные

#### `change_profile(first_name: str | None = None, last_name: str | None = None, bio: str | None = None, photo: Photo | None = None) -> bool`

!!! info "Описание"
    Изменяет информацию в профиле пользователя.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `first_name` | `str \| None` | Новое имя |
| `last_name` | `str \| None` | Новая фамилия |
| `bio` | `str \| None` | Новое описание |
| `photo` | `Photo \| None` | Новая фотография |

**Пример использования**
```python
# Обновление имени и описания
success = await client.change_profile(
    first_name="Иван",
    bio="Python разработчик"
)

# Обновление фото профиля
photo = Photo("/photos/new_profile.jpg")
success = await client.change_profile(photo=photo)
```

## 👥 Управление пользователями {#управление-пользователями}

### Получение Информации о Пользователях

#### `get_cached_user(user_id: int) -> User | None`

!!! info "Описание"
    Быстро получает информацию о пользователе из локального кэша.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `user_id` | `int` | ID пользователя |

#### `get_user(user_id: int) -> User | None`

!!! info "Описание"
    Получает актуальную информацию о пользователе.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `user_id` | `int` | ID пользователя |

#### `get_users(user_ids: list[int]) -> list[User]`

!!! info "Описание"
    Получает информацию о нескольких пользователях за один запрос.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `user_ids` | `list[int]` | Список ID пользователей |

#### `fetch_users(user_ids: list[int]) -> list[User]`

!!! info "Описание"
    Принудительно загружает актуальную информацию о пользователях с сервера.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `user_ids` | `list[int]` | Список ID пользователей |

### Поиск Пользователей

#### `search_by_phone(phone: str) -> User | None`

!!! info "Описание"
    Ищет пользователя по номеру телефона.

**Параметры**

| Параметр | Тип | Описание |
|----------|-----|----------|
| `phone` | `str` | Номер телефона |

### Управление Сессиями

#### `get_sessions() -> list[Session]`

!!! info "Описание"
    Получает список всех активных сессий текущего пользователя.

**Пример использования**
```python
sessions = await client.get_sessions()
for session in sessions:
    print(f"Сессия: {session.client} из {session.location}")
```

## 📝 Рекомендации по использованию

### Обработка Ошибок

!!! tip "Проверка результатов"
    Всегда проверяйте возвращаемые значения на None:
    ```python
    result = await client.send_message(
        chat_id=123456,
        text="Тестовое сообщение",
        notify=True
    )
    if result is None:
        print("Не удалось отправить сообщение")
    ```

!!! warning "Обработка исключений"
    Используйте try-except для обработки возможных ошибок:
    ```python
    try:
        await client.pin_message(
            chat_id=123456,
            message_id=789,
            notify_pin=True
        )
    except Exception as e:
        print(f"Ошибка при закреплении: {e}")
    ```


### Оптимизация Запросов

!!! tip "Массовые операции"
    Используйте методы для работы с множеством объектов:
    - `get_users()` вместо множества вызовов `get_user()`
    - `delete_message()` с списком ID вместо удаления по одному
