"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeployCdkStackAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cpactions = require("@aws-cdk/aws-codepipeline-actions");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const cxapi = require("@aws-cdk/cx-api");
const constructs_1 = require("constructs");
const construct_internals_1 = require("../private/construct-internals");
const fs_1 = require("../private/fs");
/**
 * (experimental) Action to deploy a CDK Stack.
 *
 * Adds two CodePipeline Actions to the pipeline: one to create a ChangeSet
 * and one to execute it.
 *
 * You do not need to instantiate this action yourself -- it will automatically
 * be added by the pipeline when you add stack artifacts or entire stages.
 *
 * @experimental
 */
class DeployCdkStackAction {
    /**
     * @experimental
     */
    constructor(props) {
        var _b, _c, _d, _e, _f;
        if (props.output && !props.outputFileName) {
            throw new Error('If \'output\' is set, \'outputFileName\' is also required');
        }
        this.stackArtifactId = props.stackArtifactId;
        this.dependencyStackArtifactIds = (_b = props.dependencyStackArtifactIds) !== null && _b !== void 0 ? _b : [];
        this.prepareRunOrder = (_c = props.prepareRunOrder) !== null && _c !== void 0 ? _c : 1;
        this.executeRunOrder = (_d = props.executeRunOrder) !== null && _d !== void 0 ? _d : this.prepareRunOrder + 1;
        this.stackName = props.stackName;
        const baseActionName = (_e = props.baseActionName) !== null && _e !== void 0 ? _e : this.stackName;
        const changeSetName = (_f = props.changeSetName) !== null && _f !== void 0 ? _f : 'PipelineChange';
        this.prepareChangeSetAction = new cpactions.CloudFormationCreateReplaceChangeSetAction({
            actionName: `${baseActionName}.Prepare`,
            changeSetName,
            runOrder: this.prepareRunOrder,
            stackName: this.stackName,
            templatePath: props.cloudAssemblyInput.atPath(props.templatePath),
            adminPermissions: false,
            role: props.actionRole,
            deploymentRole: props.cloudFormationExecutionRole,
            region: props.region,
            cfnCapabilities: [core_1.CfnCapabilities.NAMED_IAM, core_1.CfnCapabilities.AUTO_EXPAND],
            templateConfiguration: props.templateConfigurationPath ? props.cloudAssemblyInput.atPath(props.templateConfigurationPath) : undefined,
        });
        this.executeChangeSetAction = new cpactions.CloudFormationExecuteChangeSetAction({
            actionName: `${baseActionName}.Deploy`,
            changeSetName,
            runOrder: this.executeRunOrder,
            stackName: this.stackName,
            role: props.actionRole,
            region: props.region,
            outputFileName: props.outputFileName,
            output: props.output,
        });
    }
    /**
     * (experimental) Construct a DeployCdkStackAction from a Stack artifact.
     *
     * @experimental
     */
    static fromStackArtifact(scope, artifact, options) {
        var _b;
        if (!artifact.assumeRoleArn) {
            throw new Error(`Stack '${artifact.stackName}' does not have deployment role information; use the 'DefaultStackSynthesizer' synthesizer, or set the '@aws-cdk/core:newStyleStackSynthesis' context key.`);
        }
        const artRegion = artifact.environment.region;
        const region = artRegion === core_1.Stack.of(scope).region || artRegion === cxapi.UNKNOWN_REGION ? undefined : artRegion;
        const artAccount = artifact.environment.account;
        const account = artAccount === core_1.Stack.of(scope).account || artAccount === cxapi.UNKNOWN_ACCOUNT ? undefined : artAccount;
        const actionRole = roleFromPlaceholderArn(scope, region, account, artifact.assumeRoleArn);
        const cloudFormationExecutionRole = roleFromPlaceholderArn(scope, region, account, artifact.cloudFormationExecutionRoleArn);
        // We need the path of the template relative to the root Cloud Assembly
        // It should be easier to get this, but for now it is what it is.
        const appAsmRoot = construct_internals_1.assemblyBuilderOf(construct_internals_1.appOf(scope)).outdir;
        const fullTemplatePath = path.join(artifact.assembly.directory, artifact.templateFile);
        let fullConfigPath;
        if (Object.keys(artifact.tags).length > 0) {
            fullConfigPath = `${fullTemplatePath}.config.json`;
            // Write the template configuration file (for parameters into CreateChangeSet call that
            // cannot be configured any other way). They must come from a file, and there's unfortunately
            // no better hook to write this file (`construct.onSynthesize()` would have been the prime candidate
            // but that is being deprecated--and DeployCdkStackAction isn't even a construct).
            writeTemplateConfiguration(fullConfigPath, {
                Tags: artifact.tags,
            });
        }
        return new DeployCdkStackAction({
            actionRole,
            cloudFormationExecutionRole,
            templatePath: fs_1.toPosixPath(path.relative(appAsmRoot, fullTemplatePath)),
            templateConfigurationPath: fullConfigPath ? fs_1.toPosixPath(path.relative(appAsmRoot, fullConfigPath)) : undefined,
            region,
            stackArtifactId: artifact.id,
            dependencyStackArtifactIds: artifact.dependencies.filter(isStackArtifact).map(s => s.id),
            stackName: (_b = options.stackName) !== null && _b !== void 0 ? _b : artifact.stackName,
            ...options,
        });
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope, stage, options) {
        stage.addAction(this.prepareChangeSetAction);
        return this.executeChangeSetAction.bind(scope, stage, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name, target, options) {
        return this.executeChangeSetAction.onStateChange(name, target, options);
    }
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties() {
        return this.executeChangeSetAction.actionProperties;
    }
}
exports.DeployCdkStackAction = DeployCdkStackAction;
_a = JSII_RTTI_SYMBOL_1;
DeployCdkStackAction[_a] = { fqn: "@aws-cdk/pipelines.DeployCdkStackAction", version: "1.101.0" };
function roleFromPlaceholderArn(scope, region, account, arn) {
    if (!arn) {
        return undefined;
    }
    // Use placeholdered arn as construct ID.
    const id = arn;
    // https://github.com/aws/aws-cdk/issues/7255
    let existingRole = constructs_1.Node.of(scope).tryFindChild(`ImmutableRole${id}`);
    if (existingRole) {
        return existingRole;
    }
    // For when #7255 is fixed.
    existingRole = constructs_1.Node.of(scope).tryFindChild(id);
    if (existingRole) {
        return existingRole;
    }
    const arnToImport = cxapi.EnvironmentPlaceholders.replace(arn, {
        region: region !== null && region !== void 0 ? region : core_1.Aws.REGION,
        accountId: account !== null && account !== void 0 ? account : core_1.Aws.ACCOUNT_ID,
        partition: core_1.Aws.PARTITION,
    });
    return iam.Role.fromRoleArn(scope, id, arnToImport, { mutable: false });
}
function isStackArtifact(a) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return a instanceof cxapi.CloudFormationStackArtifact;
    return a.constructor.name === 'CloudFormationStackArtifact';
}
/**
 * Write template configuration to the given file
 */
function writeTemplateConfiguration(filename, config) {
    fs.writeFileSync(filename, JSON.stringify(config, undefined, 2), { encoding: 'utf-8' });
}
//# sourceMappingURL=data:application/json;base64,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