import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as ec2 from '@aws-cdk/aws-ec2';
import * as events from '@aws-cdk/aws-events';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * (experimental) Type of the asset that is being published.
 *
 * @experimental
 */
export declare enum AssetType {
    /**
     * (experimental) A file.
     *
     * @experimental
     */
    FILE = "file",
    /**
     * (experimental) A Docker image.
     *
     * @experimental
     */
    DOCKER_IMAGE = "docker-image"
}
/**
 * (experimental) Props for a PublishAssetsAction.
 *
 * @experimental
 */
export interface PublishAssetsActionProps {
    /**
     * (experimental) Name of publishing action.
     *
     * @experimental
     */
    readonly actionName: string;
    /**
     * (experimental) The CodePipeline artifact that holds the Cloud Assembly.
     *
     * @experimental
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * (experimental) AssetType we're publishing.
     *
     * @experimental
     */
    readonly assetType: AssetType;
    /**
     * (experimental) Version of CDK CLI to 'npm install'.
     *
     * @default - Latest version
     * @experimental
     */
    readonly cdkCliVersion?: string;
    /**
     * (experimental) Name of the CodeBuild project.
     *
     * @default - Automatically generated
     * @experimental
     */
    readonly projectName?: string;
    /**
     * (experimental) Role to use for CodePipeline and CodeBuild to build and publish the assets.
     *
     * @default - Automatically generated
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The VPC where to execute the PublishAssetsAction.
     *
     * @default - No VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
}
/**
 * (experimental) Action to publish an asset in the pipeline.
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to prepare and publish the asset.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline when you add stacks that use assets.
 *
 * @experimental
 */
export declare class PublishAssetsAction extends CoreConstruct implements codepipeline.IAction {
    private readonly props;
    private readonly action;
    private readonly commands;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PublishAssetsActionProps);
    /**
     * (experimental) Add a single publishing command.
     *
     * Manifest path should be relative to the root Cloud Assembly.
     *
     * @experimental
     */
    addPublishCommand(relativeManifestPath: string, assetSelector: string): void;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties(): codepipeline.ActionProperties;
}
