"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloudAssemblyBuildSpecDir = exports.embeddedAsmPath = exports.assemblyBuilderOf = exports.appOf = void 0;
/**
 * Get access to construct internals that we need but got removed from the Stages PR.
 */
const path = require("path");
const core_1 = require("@aws-cdk/core");
const constructs_1 = require("constructs");
function appOf(construct) {
    const root = constructs_1.Node.of(construct).root;
    if (!core_1.App.isApp(root)) {
        throw new Error(`Construct must be created under an App, but is not: ${constructs_1.Node.of(construct).path}`);
    }
    return root;
}
exports.appOf = appOf;
function assemblyBuilderOf(stage) {
    return stage._assemblyBuilder;
}
exports.assemblyBuilderOf = assemblyBuilderOf;
/**
 * Return the relative path from the app assembly to the scope's (nested) assembly
 */
function embeddedAsmPath(scope) {
    var _a;
    const appAsmRoot = assemblyBuilderOf(appOf(scope)).outdir;
    const stage = (_a = core_1.Stage.of(scope)) !== null && _a !== void 0 ? _a : appOf(scope);
    const stageAsmRoot = assemblyBuilderOf(stage).outdir;
    return path.relative(appAsmRoot, stageAsmRoot) || '.';
}
exports.embeddedAsmPath = embeddedAsmPath;
/**
 * Determine the directory where the cloud assembly will be written, for use in a BuildSpec
 */
function cloudAssemblyBuildSpecDir(scope) {
    return assemblyBuilderOf(appOf(scope)).outdir;
}
exports.cloudAssemblyBuildSpecDir = cloudAssemblyBuildSpecDir;
//# sourceMappingURL=data:application/json;base64,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