"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toPosixPath = void 0;
const path = require("path");
/**
 * Convert a file path on the current system to a file path that can be used on Linux
 *
 * Takes the current OS' file separator and replaces all of them with a '/'.
 *
 * Relevant if the current system is a Windows machine but is generating
 * commands for a Linux CodeBuild image.
 */
function toPosixPath(osPath, currentSep) {
    const regex = new RegExp(`\\${currentSep !== null && currentSep !== void 0 ? currentSep : path.sep}`, 'g');
    return osPath.replace(regex, '/');
}
exports.toPosixPath = toPosixPath;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJmcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFFN0I7Ozs7Ozs7R0FPRztBQUNILFNBQWdCLFdBQVcsQ0FBQyxNQUFjLEVBQUUsVUFBbUI7SUFDN0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQUMsS0FBSyxVQUFVLGFBQVYsVUFBVSxjQUFWLFVBQVUsR0FBSSxJQUFJLENBQUMsR0FBRyxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDN0QsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FBQztBQUNwQyxDQUFDO0FBSEQsa0NBR0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuXG4vKipcbiAqIENvbnZlcnQgYSBmaWxlIHBhdGggb24gdGhlIGN1cnJlbnQgc3lzdGVtIHRvIGEgZmlsZSBwYXRoIHRoYXQgY2FuIGJlIHVzZWQgb24gTGludXhcbiAqXG4gKiBUYWtlcyB0aGUgY3VycmVudCBPUycgZmlsZSBzZXBhcmF0b3IgYW5kIHJlcGxhY2VzIGFsbCBvZiB0aGVtIHdpdGggYSAnLycuXG4gKlxuICogUmVsZXZhbnQgaWYgdGhlIGN1cnJlbnQgc3lzdGVtIGlzIGEgV2luZG93cyBtYWNoaW5lIGJ1dCBpcyBnZW5lcmF0aW5nXG4gKiBjb21tYW5kcyBmb3IgYSBMaW51eCBDb2RlQnVpbGQgaW1hZ2UuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiB0b1Bvc2l4UGF0aChvc1BhdGg6IHN0cmluZywgY3VycmVudFNlcD86IHN0cmluZykge1xuICBjb25zdCByZWdleCA9IG5ldyBSZWdFeHAoYFxcXFwke2N1cnJlbnRTZXAgPz8gcGF0aC5zZXB9YCwgJ2cnKTtcbiAgcmV0dXJuIG9zUGF0aC5yZXBsYWNlKHJlZ2V4LCAnLycpO1xufSJdfQ==